/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.collection.ICacheMap;
import org.voovan.tools.collection.ScanedObject;
import org.voovan.tools.serialize.TSerialize;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisMap<K, V>
implements ICacheMap<K, V>,
Closeable {
    public static final String LOCK_SUCCESS = "OK";
    public static final Long UNLOCK_SUCCESS = 1L;
    public static final String SET_NOT_EXIST = "NX";
    public static final String SET_EXPIRE_TIME = "PX";
    private long expire = 0L;
    private JedisPool redisPool;
    private String name = null;
    private int dbIndex = 0;
    private Function<K, V> supplier = null;

    public RedisMap(String host, int port, int timeout, int poolsize, String name, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.name = name;
    }

    public RedisMap(String host, int port, int timeout, int poolsize, String name) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.name = name;
    }

    public RedisMap(String host, int port, int timeout, int poolsize) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
    }

    public RedisMap(String name) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.name = name;
    }

    public RedisMap(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.name = name;
    }

    public RedisMap(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public RedisMap() {
        this.redisPool = CacheStatic.getDefaultRedisPool();
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public RedisMap<K, V> dbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
        return this;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    @Override
    public Function<K, V> getSupplier() {
        return this.supplier;
    }

    @Override
    public RedisMap<K, V> supplier(Function<K, V> supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    public long getExpire() {
        return this.expire;
    }

    @Override
    public RedisMap<K, V> expire(long expire) {
        this.expire = expire;
        return this;
    }

    @Override
    public int size() {
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                int n = Integer.valueOf(String.valueOf(jedis.dbSize()));
                return n;
            }
            int n = Integer.valueOf(String.valueOf(jedis.hlen(this.name)));
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        byte[] keyByteArray = TSerialize.serialize(key);
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                boolean bl = jedis.exists(keyByteArray);
                return bl;
            }
            boolean bl = jedis.hexists(this.name.getBytes(), keyByteArray);
            return bl;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key, Function<K, V> appointedSupplier, Long createExpire, boolean refresh) {
        byte[] valueByteArray;
        byte[] keyByteArray = TSerialize.serialize(key);
        try (Jedis jedis = this.getJedis();){
            valueByteArray = this.name == null ? jedis.get(keyByteArray) : jedis.hget(this.name.getBytes(), keyByteArray);
        }
        appointedSupplier = appointedSupplier == null ? this.supplier : appointedSupplier;
        createExpire = createExpire == null ? this.expire : createExpire;
        if (valueByteArray == null && appointedSupplier != null) {
            Function<K, V> function = appointedSupplier;
            synchronized (function) {
                V value = appointedSupplier.apply(key);
                if (createExpire == 0L) {
                    this.put(key, value);
                } else {
                    this.put(key, value, createExpire);
                }
                return value;
            }
        }
        if (refresh && this.name == null && createExpire != null) {
            this.setTTL(key, createExpire);
        }
        return (V)TSerialize.unserialize(valueByteArray);
    }

    @Override
    public V put(K key, V value) {
        if (this.expire != 0L) {
            return this.put(key, value, this.expire);
        }
        byte[] keyByteArray = TSerialize.serialize(key);
        byte[] valueByteArray = TSerialize.serialize(value);
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                if (jedis.set(keyByteArray, valueByteArray).equals(LOCK_SUCCESS)) {
                    V v = value;
                    return v;
                }
                V v = null;
                return v;
            }
            if (jedis.hset(this.name.getBytes(), keyByteArray, valueByteArray) == 1L) {
                V v = null;
                return v;
            }
            V v = value;
            return v;
        }
    }

    @Override
    public V put(K key, V value, long expire) {
        byte[] keyByteArray = TSerialize.serialize(key);
        byte[] valueByteArray = TSerialize.serialize(value);
        Throwable throwable = null;
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                if (jedis.setex(keyByteArray, (int)expire, valueByteArray).equals(LOCK_SUCCESS)) {
                    V v = value;
                    return v;
                }
                V v = null;
                return v;
            }
            try {
                throw new UnsupportedOperationException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.expire != 0L) {
            return this.putIfAbsent(key, value, this.expire);
        }
        byte[] keyByteArray = TSerialize.serialize(key);
        byte[] valueByteArray = TSerialize.serialize(value);
        try (Jedis jedis = this.getJedis();){
            byte[] valueBytes;
            long result = 0L;
            if (this.name == null) {
                result = jedis.setnx(keyByteArray, valueByteArray);
                if (result == 1L) {
                    value = null;
                } else {
                    valueBytes = jedis.get(keyByteArray);
                    if (valueBytes == null) {
                        Object v = this.get(key);
                        return v;
                    }
                    value = TSerialize.unserialize(valueBytes);
                }
            } else {
                result = jedis.hsetnx(this.name.getBytes(), keyByteArray, valueByteArray);
                if (result == 1L) {
                    value = null;
                } else {
                    valueBytes = jedis.hget(this.name.getBytes(), keyByteArray);
                    if (valueBytes == null) {
                        Object v = this.get(key);
                        return v;
                    }
                    value = TSerialize.unserialize(valueBytes);
                }
            }
            V v = value;
            return v;
        }
    }

    @Override
    public V putIfAbsent(K key, V value, long expire) {
        byte[] keyByteArray = TSerialize.serialize(key);
        byte[] valueByteArray = TSerialize.serialize(value);
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                String result = jedis.set(keyByteArray, valueByteArray, SET_NOT_EXIST.getBytes(), SET_EXPIRE_TIME.getBytes(), expire * 1000L);
                if (!LOCK_SUCCESS.equals(result)) {
                    Object v = this.get(key);
                    return v;
                }
                value = null;
            } else {
                throw new UnsupportedOperationException();
            }
            V v = value;
            return v;
        }
    }

    @Override
    public boolean setTTL(K key, long expire) {
        byte[] keyByteArray = TSerialize.serialize(key);
        Throwable throwable = null;
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                boolean bl = jedis.expire(keyByteArray, (int)expire) == 1L;
                return bl;
            }
            try {
                throw new UnsupportedOperationException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public long getTTL(K key) {
        byte[] keyByteArray = TSerialize.serialize(key);
        Throwable throwable = null;
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                long l = jedis.ttl(keyByteArray);
                return l;
            }
            try {
                throw new UnsupportedOperationException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean persist(K key) {
        byte[] keyByteArray = TSerialize.serialize(key);
        Throwable throwable = null;
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                boolean bl = jedis.persist(keyByteArray) == 1L;
                return bl;
            }
            try {
                throw new UnsupportedOperationException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public V remove(Object key) {
        byte[] keyByteArray = TSerialize.serialize(key);
        try (Jedis jedis = this.getJedis();){
            byte[] valueByteArray;
            Object value = null;
            if (this.name == null) {
                valueByteArray = jedis.get(keyByteArray);
                if (valueByteArray != null) {
                    jedis.del(keyByteArray);
                }
            } else {
                valueByteArray = jedis.hget(this.name.getBytes(), keyByteArray);
                if (valueByteArray != null) {
                    jedis.hdel(this.name.getBytes(), (byte[][])new byte[][]{keyByteArray});
                }
            }
            Object object = TSerialize.unserialize(valueByteArray);
            return (V)object;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try (Jedis jedis = this.getJedis();){
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> obj;
                Map.Entry<K, V> entry = obj = iterator.next();
                byte[] keyByteArray = TSerialize.serialize(entry.getKey());
                byte[] valueByteArray = TSerialize.serialize(entry.getValue());
                if (this.name == null) {
                    jedis.set(keyByteArray, valueByteArray);
                    continue;
                }
                jedis.hset(this.name.getBytes(), keyByteArray, valueByteArray);
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long expire) {
        try (Jedis jedis = this.getJedis();){
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> obj;
                Map.Entry<K, V> entry = obj = iterator.next();
                byte[] keyByteArray = TSerialize.serialize(entry.getKey());
                byte[] valueByteArray = TSerialize.serialize(entry.getValue());
                if (this.name == null) {
                    jedis.setex(keyByteArray, (int)expire, valueByteArray);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void clear() {
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                jedis.flushDB();
            } else {
                jedis.del(this.name);
            }
        }
    }

    @Override
    public Set<K> keySet() {
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                Set set = jedis.keys("*".getBytes()).parallelStream().map(new Function<byte[], Object>(){

                    @Override
                    public Object apply(byte[] bytes) {
                        return TSerialize.unserialize(bytes);
                    }
                }).collect(Collectors.toSet());
                return set;
            }
            Set set = jedis.hkeys(this.name.getBytes()).parallelStream().map(new Function<byte[], Object>(){

                @Override
                public Object apply(byte[] bytes) {
                    return TSerialize.unserialize(bytes);
                }
            }).collect(Collectors.toSet());
            return set;
        }
    }

    public Set<K> keySet(String pattern) {
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                Set set = jedis.hkeys(pattern.getBytes()).stream().map(new Function<byte[], K>(){

                    @Override
                    public K apply(byte[] bytes) {
                        return TSerialize.unserialize(bytes);
                    }
                }).collect(Collectors.toSet());
                return set;
            }
            Set set = jedis.keys(pattern.getBytes()).parallelStream().map(new Function<byte[], Object>(){

                @Override
                public Object apply(byte[] bytes) {
                    return TSerialize.unserialize(bytes);
                }
            }).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public Collection<V> values() {
        try (Jedis jedis = this.getJedis();){
            if (this.name == null) {
                throw new UnsupportedOperationException();
            }
            Collection collection = jedis.hvals(this.name.getBytes()).stream().map(new Function<byte[], V>(){

                @Override
                public V apply(byte[] bytes) {
                    return TSerialize.unserialize(bytes);
                }
            }).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public long incr(K key, long value) {
        block15: {
            byte[] keyByteArray = TSerialize.serialize(key);
            try (Jedis jedis = this.getJedis();){
                if (this.name == null) {
                    value = jedis.incrBy(keyByteArray, value);
                    break block15;
                }
                long l = value = jedis.hincrBy(this.name.getBytes(), keyByteArray, value).longValue();
                return l;
            }
        }
        return -1L;
    }

    public double incrFloat(K key, double value) {
        block15: {
            byte[] keyByteArray = TSerialize.serialize(key);
            try (Jedis jedis = this.getJedis();){
                if (this.name == null) {
                    value = jedis.incrByFloat(keyByteArray, value);
                    break block15;
                }
                double d = value = jedis.hincrByFloat(this.name.getBytes(), keyByteArray, value).doubleValue();
                return d;
            }
        }
        return -1.0;
    }

    @Override
    public void close() throws IOException {
        this.redisPool.close();
    }

    public ScanedObject scan(String cursor, V matchValue, Integer count) {
        try (Jedis jedis = this.getJedis();){
            byte[] matchValueByteArray = TSerialize.serialize(matchValue);
            ScanParams scanParams = new ScanParams();
            if (matchValue != null) {
                scanParams.match(matchValueByteArray);
            }
            if (count != null) {
                scanParams.count(count);
            }
            if (this.name == null) {
                ScanResult scanResult = jedis.scan(cursor.getBytes(), scanParams);
                ScanedObject scanedObject = new ScanedObject(scanResult.getStringCursor());
                for (byte[] keyBytes : scanResult.getResult()) {
                    scanedObject.getResultList().add(TSerialize.unserialize(keyBytes));
                }
                ScanedObject scanedObject2 = scanedObject;
                return scanedObject2;
            }
            ScanResult scanResult = jedis.hscan(this.name.getBytes(), cursor.getBytes(), scanParams);
            ScanedObject scanedObject = new ScanedObject(scanResult.getStringCursor());
            for (Map.Entry entryItem : scanResult.getResult()) {
                AbstractMap.SimpleEntry<Object, Object> entry = new AbstractMap.SimpleEntry<Object, Object>(TSerialize.unserialize((byte[])entryItem.getKey()), TSerialize.unserialize((byte[])entryItem.getValue()));
                scanedObject.getResultList().add(entry);
            }
            ScanedObject scanedObject3 = scanedObject;
            return scanedObject3;
        }
    }
}

