/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.Collections;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.TEnv;
import org.voovan.tools.TString;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.collection.RedisMap;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisLock {
    private JedisPool redisPool;
    private String lockName = null;
    private int dbIndex = 0;
    private String lockValue = TString.generateShortUUID();

    public RedisLock(String host, int port, int timeout, int poolsize, String lockName, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.lockName = lockName;
    }

    public RedisLock(String host, int port, int timeout, int poolsize, String lockName) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.lockName = lockName;
    }

    public RedisLock(String lockName) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.lockName = lockName;
    }

    public RedisLock(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.lockName = this.lockName;
    }

    public RedisLock(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    public boolean tryLock(String lockValue, int lockExpireTime) {
        if (lockValue == null) {
            lockValue = String.valueOf(System.currentTimeMillis());
        }
        try (Jedis jedis = this.getJedis();){
            String result = jedis.set(this.lockName, lockValue, "NX", "PX", lockExpireTime);
            this.lockValue = lockValue;
            if ("OK".equals(result)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean tryLock(int lockExpireTime) {
        return this.tryLock(null, lockExpireTime);
    }

    public boolean lock(String lockValue, int lockExpireTime, int timewait) {
        if (lockValue == null) {
            lockValue = this.lockValue;
        }
        long start = System.currentTimeMillis();
        while (true) {
            Jedis jedis = this.getJedis();
            Throwable throwable = null;
            try {
                String result = jedis.set(this.lockName, lockValue, "NX", "PX", lockExpireTime);
                if ("OK".equals(result)) {
                    boolean bl = true;
                    return bl;
                }
                if (System.currentTimeMillis() - start > (long)timewait) break;
                TEnv.sleep(1);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jedis == null) continue;
                if (throwable != null) {
                    try {
                        jedis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jedis.close();
                continue;
            }
            break;
        }
        return false;
    }

    public boolean lock(int lockExpireTime, int timewait) {
        return this.lock(null, lockExpireTime, timewait);
    }

    public boolean unLock() {
        try (Jedis jedis = this.getJedis();){
            String script = "if redis.call('getThread', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = jedis.eval(script, Collections.singletonList(this.lockName), Collections.singletonList(this.lockValue));
            if (RedisMap.UNLOCK_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean unLock(String lockValue) {
        try (Jedis jedis = this.getJedis();){
            String script = "if redis.call('getThread', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = jedis.eval(script, Collections.singletonList(this.lockName), Collections.singletonList(this.lockValue));
            if (RedisMap.UNLOCK_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

