/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.tools.json.JSON;

public class MultiMap<K, V>
extends ConcurrentHashMap<K, List<V>> {
    public MultiMap() {
    }

    public MultiMap(Map<K, List<V>> map) {
        super(map);
    }

    public List<V> getValues(K key) {
        List vals = (List)super.get(key);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return vals;
    }

    public V getValue(K key, int i) {
        List<V> vals = this.getValues(key);
        if (vals == null) {
            return null;
        }
        if (i == 0 && vals.isEmpty()) {
            return null;
        }
        return vals.get(i);
    }

    public List<V> putValue(K key, V value) {
        if (value == null) {
            return super.put(key, null);
        }
        List<V> vals = this.getValueList(key);
        vals.add(value);
        return vals;
    }

    public void putAllValues(Map<K, V> input) {
        for (Map.Entry<K, V> entry : input.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
    }

    public List<V> putValues(K key, List<V> values) {
        return super.put(key, values);
    }

    private List<V> getValueList(K key) {
        Vector lo = (Vector)this.get(key);
        if (lo == null) {
            lo = new Vector();
            List retValue = this.putIfAbsent(key, lo);
            lo = retValue == null ? lo : retValue;
        }
        return lo;
    }

    @SafeVarargs
    public final List<V> putValues(K key, V ... values) {
        List<V> list = this.getValueList(key);
        list.addAll(Arrays.asList(values));
        return super.put(key, list);
    }

    public void add(K key, V value) {
        List<V> lo = this.getValueList(key);
        lo.add(value);
        super.put(key, lo);
    }

    public void addValues(K key, List<V> values) {
        List<V> lo = this.getValueList(key);
        lo.addAll(values);
        super.put(key, lo);
    }

    public void addValues(K key, V[] values) {
        List<V> lo = this.getValueList(key);
        lo.addAll(Arrays.asList(values));
        super.put(key, lo);
    }

    public boolean addAllValues(MultiMap<K, V> map) {
        boolean merged = false;
        if (map == null || map.isEmpty()) {
            return merged;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object name = entry.getKey();
            List values = (List)entry.getValue();
            if (this.containsKey(name)) {
                merged = true;
            }
            this.addValues(name, values);
        }
        return merged;
    }

    public V removeValue(K key, int index) {
        List lo = (List)this.get(key);
        if (lo == null || lo.isEmpty()) {
            return null;
        }
        Object ret = lo.remove(index);
        if (lo.isEmpty()) {
            this.remove(key);
        }
        return (V)ret;
    }

    public boolean removeValue(K key, V value) {
        List lo = (List)this.get(key);
        if (lo == null || lo.isEmpty()) {
            return false;
        }
        boolean ret = lo.remove(value);
        if (lo.isEmpty()) {
            this.remove(key);
        }
        return ret;
    }

    public boolean containsValues(V value) {
        for (List vals : this.values()) {
            if (vals.size() <= 0 || !vals.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return JSON.toJSON(this);
    }
}

