/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class Chain<E>
extends ArrayList<E> {
    public ThreadLocal<AtomicInteger> iteratorLocal = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    public ThreadLocal<AtomicInteger> invertedIteratorLocal = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private boolean isStop = false;

    public Chain() {
        this.rewind();
    }

    public Chain<E> rewind() {
        this.isStop = false;
        this.iteratorLocal.get().set(0);
        this.invertedIteratorLocal.get().set(this.size() - 1);
        return this;
    }

    public void stop() {
        this.isStop = true;
    }

    public E next() {
        if (this.isStop) {
            return null;
        }
        if (this.hasNext()) {
            Object e = this.get(this.iteratorLocal.get().getAndIncrement());
            return e;
        }
        return null;
    }

    public boolean hasNext() {
        if (this.isStop) {
            return false;
        }
        return this.iteratorLocal.get().get() <= this.size() - 1;
    }

    public E previous() {
        if (this.isStop) {
            return null;
        }
        if (this.hasPrevious()) {
            return this.get(this.invertedIteratorLocal.get().getAndDecrement());
        }
        return null;
    }

    public boolean hasPrevious() {
        if (this.isStop) {
            return false;
        }
        return this.invertedIteratorLocal.get().get() >= 0;
    }
}

