/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.voovan.tools.TEnv;
import org.voovan.tools.collection.CollectionSearch;
import org.voovan.tools.collection.ICacheMap;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.hashwheeltimer.HashWheelTimer;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.annotation.NotSerialization;

public class CachedMap<K, V>
implements ICacheMap<K, V> {
    protected static final HashWheelTimer wheelTimer = new HashWheelTimer(60, 1000);
    private Function<K, V> supplier = null;
    private int interval = 1;
    private boolean autoRemove = true;
    private BiFunction<K, V, Long> destory;
    private long expire = 0L;
    private Map<K, V> cacheData = null;
    private ConcurrentHashMap<K, TimeMark> cacheMark = new ConcurrentHashMap();
    private int maxSize;

    public CachedMap(Map<K, V> map) {
        this.maxSize = map.size();
        this.cacheData = map;
    }

    public CachedMap(Integer maxSize) {
        this.maxSize = maxSize == null ? Integer.MAX_VALUE : maxSize;
        this.cacheData = new ConcurrentHashMap(maxSize);
    }

    public CachedMap() {
        this.maxSize = Integer.MAX_VALUE;
        this.cacheData = new ConcurrentHashMap();
    }

    @Override
    public Function<K, V> getSupplier() {
        return this.supplier;
    }

    @Override
    public CachedMap<K, V> supplier(Function<K, V> buildFunction) {
        this.supplier = buildFunction;
        this.autoRemove = false;
        return this;
    }

    public BiFunction<K, V, Long> getDestory() {
        return this.destory;
    }

    public CachedMap<K, V> destory(BiFunction<K, V, Long> destory) {
        this.destory = destory;
        return this;
    }

    public CachedMap<K, V> maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public CachedMap<K, V> interval(int interval) {
        this.interval = interval;
        return this;
    }

    public CachedMap<K, V> autoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    @Override
    public long getExpire() {
        return this.expire;
    }

    @Override
    public CachedMap expire(long expire) {
        this.expire = expire;
        return this;
    }

    public ConcurrentHashMap<K, TimeMark> getCacheMark() {
        return this.cacheMark;
    }

    public CachedMap<K, V> create() {
        final CachedMap cachedMap = this;
        if (this.interval >= 1) {
            wheelTimer.addTask(new HashWheelTask(){

                @Override
                public void run() {
                    if (!cachedMap.getCacheMark().isEmpty()) {
                        for (TimeMark timeMark : cachedMap.getCacheMark().values().toArray(new TimeMark[0])) {
                            cachedMap.checkAndDoExpire(timeMark);
                        }
                        CachedMap.this.fixSize();
                    }
                }
            }, this.interval);
        }
        return this;
    }

    public void checkAndDoExpire(K key) {
        this.checkAndDoExpire(this.cacheMark.get(key));
    }

    private void checkAndDoExpire(TimeMark<K> timeMark) {
        if (timeMark != null && timeMark.isExpire()) {
            if (this.autoRemove) {
                if (this.destory != null) {
                    Long value = this.destory.apply(timeMark.getKey(), this.get(((TimeMark)timeMark).key));
                    if (value < 0L) {
                        this.remove(timeMark.getKey());
                        this.cacheMark.remove(timeMark.getKey());
                    } else if (value == null) {
                        timeMark.refresh(true);
                    } else {
                        timeMark.setExpireTime(value);
                    }
                } else {
                    this.cacheMark.remove(timeMark.getKey());
                    this.remove(timeMark.getKey());
                }
            } else if (this.getSupplier() != null) {
                this.createCache(timeMark.getKey(), this.supplier, timeMark.getExpireTime());
                timeMark.refresh(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeMark createCache(K key, Function<K, V> supplier, Long createExpire) {
        if (supplier == null) {
            return null;
        }
        TimeMark timeMark = null;
        Serializable serializable = this.cacheMark;
        synchronized (serializable) {
            timeMark = this.cacheMark.get(key);
            if (timeMark == null) {
                timeMark = new TimeMark(this, key, createExpire);
                this.cacheMark.put(key, timeMark);
            }
        }
        serializable = timeMark.createFlag;
        synchronized (serializable) {
            if (timeMark.tryLockOnCreate()) {
                this.generator(key, supplier, timeMark, createExpire);
            }
        }
        try {
            TimeMark finalTimeMark = timeMark;
            TEnv.wait(10000, () -> finalTimeMark.isOnCreate());
        }
        catch (TimeoutException e) {
            Logger.error("wait supplier timeout: " + key, e);
        }
        return timeMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generator(K key, Function<K, V> supplier, TimeMark timeMark, Long createExpire) {
        try {
            V value = supplier.apply(key);
            timeMark.refresh(true);
            if (this.expire == Long.MAX_VALUE) {
                this.put(key, value);
            } else {
                this.put(key, value, createExpire);
            }
        }
        catch (Exception e) {
            Logger.error("Create with supplier failed: ", e);
        }
        finally {
            timeMark.releaseCreateLock();
        }
    }

    @Override
    public V get(Object key, Function<K, V> appointedSupplier, Long createExpire, boolean refresh) {
        TimeMark timeMark = this.cacheMark.get(key);
        if (timeMark != null && !timeMark.isExpire() && !timeMark.isOnCreate()) {
            timeMark.refresh(refresh);
        } else if (appointedSupplier != null || this.supplier != null) {
            appointedSupplier = appointedSupplier == null ? this.supplier : appointedSupplier;
            createExpire = createExpire == null ? this.expire : createExpire;
            timeMark = this.createCache(key, appointedSupplier, createExpire);
        }
        this.checkAndDoExpire(timeMark);
        return this.cacheData.get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.expire);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m, long expire) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.cacheMark.put(e.getKey(), new TimeMark<K>(this, e.getKey(), expire));
        }
        this.cacheData.putAll(m);
    }

    @Override
    public int size() {
        return this.cacheData.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheData.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheData.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cacheData.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        this.put(key, value, this.expire);
        return value;
    }

    @Override
    public V put(K key, V value, long expire) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.cacheMark.putIfAbsent(key, new TimeMark<K>(this, key, expire));
        return this.cacheData.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.expire);
    }

    @Override
    public V putIfAbsent(K key, V value, long expire) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        V result = this.cacheData.putIfAbsent(key, value);
        this.cacheMark.putIfAbsent(key, new TimeMark<K>(this, key, expire));
        if (result != null) {
            return result;
        }
        return null;
    }

    public boolean isExpire(String key) {
        return this.cacheMark.get(key).isExpire();
    }

    private void fixSize() {
        int diffSize = this.size() - this.maxSize;
        if (diffSize > 0) {
            TimeMark[] removedTimeMark;
            for (TimeMark timeMark : removedTimeMark = CollectionSearch.newInstance(this.cacheMark.values()).addCondition("expireTime", CollectionSearch.Operate.NOT_EQUAL, 0L).addCondition("lastTime", CollectionSearch.Operate.LESS, System.currentTimeMillis() - 1000L).sort("visitCount").limit(10 * diffSize).sort("lastTime").limit(diffSize).search().toArray(new TimeMark[0])) {
                System.out.println("remove");
                this.cacheMark.remove(timeMark.getKey());
                this.remove(timeMark.getKey());
            }
        }
    }

    @Override
    public long getTTL(K key) {
        TimeMark timeMark = this.cacheMark.get(key);
        if (timeMark != null) {
            return timeMark.getExpireTime();
        }
        return -1L;
    }

    @Override
    public boolean setTTL(K key, long expire) {
        TimeMark timeMark = this.cacheMark.get(key);
        if (timeMark == null) {
            return false;
        }
        timeMark.setExpireTime(expire);
        timeMark.refresh(true);
        return true;
    }

    @Override
    public V remove(Object key) {
        this.cacheMark.remove(key);
        return this.cacheData.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.cacheMark.remove(key);
        return this.cacheData.remove(key, value);
    }

    @Override
    public void clear() {
        this.cacheMark.clear();
        this.cacheData.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.cacheData.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.cacheData.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cacheData.entrySet();
    }

    static {
        wheelTimer.rotate();
    }

    private class TimeMark<K> {
        @NotSerialization
        private CachedMap<K, V> mainMap;
        private K key;
        private AtomicLong expireTime = new AtomicLong(0L);
        private AtomicLong lastTime = new AtomicLong(0L);
        private volatile AtomicLong visitCount = new AtomicLong(0L);
        private volatile AtomicBoolean createFlag = new AtomicBoolean(false);

        public TimeMark(CachedMap<K, V> mainMap, K key, long expireTime) {
            this.key = key;
            this.mainMap = mainMap;
            this.expireTime.set(expireTime);
            this.visitCount.set(0L);
            this.refresh(true);
        }

        public void refresh(boolean updateLastTime) {
            this.visitCount.incrementAndGet();
            if (updateLastTime) {
                this.lastTime.set(System.currentTimeMillis());
            }
        }

        public boolean isExpire() {
            return this.expireTime.get() > 0L && System.currentTimeMillis() - this.lastTime.get() >= this.expireTime.get() * 1000L;
        }

        public CachedMap<K, V> getMainMap() {
            return this.mainMap;
        }

        public K getKey() {
            return this.key;
        }

        public long getExpireTime() {
            return this.expireTime.get();
        }

        public void setExpireTime(long expireTime) {
            this.expireTime.set(expireTime);
        }

        public Long getLastTime() {
            return this.lastTime.get();
        }

        public AtomicLong getVisitCount() {
            return this.visitCount;
        }

        public boolean isOnCreate() {
            return this.createFlag.get();
        }

        public boolean tryLockOnCreate() {
            return this.createFlag.compareAndSet(false, true);
        }

        public void releaseCreateLock() {
            this.createFlag.set(false);
        }
    }
}

