/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.TPerformance;
import org.voovan.tools.TProperties;
import org.voovan.tools.log.Logger;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class CacheStatic {
    private static final String DEFAULT = "system_default";
    private static ConcurrentHashMap<String, JedisPool> REDIS_POOL_CACHE = new ConcurrentHashMap();

    public static JedisPool getDefaultRedisPool() {
        JedisPool redisPool = REDIS_POOL_CACHE.get(DEFAULT);
        if (redisPool == null) {
            try {
                String host = TProperties.getString("redis", "Host");
                int port = TProperties.getInt("redis", "Port");
                int timeout = TProperties.getInt("redis", "Timeout");
                String password = TProperties.getString("redis", "Password");
                int poolSize = TProperties.getInt("redis", "PoolSize");
                redisPool = CacheStatic.createRedisPool(DEFAULT, host, port, timeout, password, poolSize);
            }
            catch (Exception e) {
                Logger.error("Read ./classes/Memcached.properties error");
            }
        }
        return redisPool;
    }

    public static JedisPool getRedisPool(String name) {
        return REDIS_POOL_CACHE.get(name);
    }

    @Deprecated
    public static JedisPool getRedisPool() {
        return CacheStatic.getDefaultRedisPool();
    }

    public static synchronized JedisPool createRedisPool(String name, String host, int port, int timeout, String password, int poolSize) {
        JedisPool redisPool = REDIS_POOL_CACHE.get(name);
        if (redisPool != null) {
            return redisPool;
        }
        if (host == null) {
            return null;
        }
        if (poolSize == 0) {
            poolSize = CacheStatic.defaultPoolSize();
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(poolSize);
        poolConfig.setMaxIdle(poolSize);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        REDIS_POOL_CACHE.put(name, redisPool);
        return redisPool;
    }

    public static int defaultPoolSize() {
        return TPerformance.getProcessorCount() * 10;
    }
}

