/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;

public class ArraySet<E>
extends AbstractSet<E> {
    Object[] elements;
    volatile int size;

    public ArraySet(int cap) {
        this.elements = new Object[cap];
    }

    public E[] getElements() {
        return this.elements;
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    public void set(int index, E e) {
        this.elements[index] = e;
        if (index >= this.size) {
            ++this.size;
        }
    }

    public E getAndRemove(int index) {
        Object e = this.elements[index];
        this.elements[index] = null;
        --this.size;
        return (E)e;
    }

    @Override
    public boolean add(E objet) {
        this.elements[this.size++] = objet;
        if (this.elements.length == this.size) {
            this.reallocate();
        }
        return true;
    }

    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    private synchronized void reallocate() {
        this.elements = Arrays.copyOf(this.elements, this.elements.length << 1);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public E remove(int index) {
        Object value = this.elements[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        this.elements[--this.size] = null;
        return (E)value;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "size: " + this.size();
    }
}

