/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.bucket;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.voovan.tools.TEnv;
import org.voovan.tools.bucket.Bucket;
import org.voovan.tools.hashwheeltimer.HashWheelTask;

public class TokenBucket
extends Bucket {
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private long lastVisitTime = System.currentTimeMillis();
    private int releaseTime = Integer.MAX_VALUE;

    public TokenBucket(int tokenSize, int interval, int releaseTime) {
        this.init(tokenSize, interval, releaseTime);
    }

    public TokenBucket(int tokenSize, int interval) {
        this.init(tokenSize, interval, Integer.MAX_VALUE);
    }

    public void init(final int tokenSize, int interval, final int releaseTime) {
        this.releaseTime = releaseTime;
        this.hashWheelTask = new HashWheelTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - TokenBucket.this.lastVisitTime >= (long)releaseTime) {
                    this.cancel();
                } else {
                    TokenBucket.this.atomicInteger.getAndUpdate(val -> {
                        if (val >= tokenSize) {
                            return tokenSize;
                        }
                        return val + tokenSize;
                    });
                }
            }
        };
        this.atomicInteger.set(tokenSize);
        Bucket.BUCKET_HASH_WHEEL_TIMER.addTask(this.hashWheelTask, interval);
    }

    public int getReleaseTime() {
        return this.releaseTime;
    }

    public void setReleaseTime(int releaseTime) {
        this.releaseTime = releaseTime;
    }

    @Override
    public boolean acquire() {
        this.lastVisitTime = System.currentTimeMillis();
        int value = this.atomicInteger.getAndUpdate(val -> {
            if (val <= 0) {
                return 0;
            }
            return val - 1;
        });
        return value > 0;
    }

    @Override
    public void acquire(int timeout) throws TimeoutException {
        this.lastVisitTime = System.currentTimeMillis();
        TEnv.wait(timeout, () -> !this.acquire());
    }
}

