/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.aop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.aop.CutPointInfo;
import org.voovan.tools.aop.annotation.Abnormal;
import org.voovan.tools.aop.annotation.After;
import org.voovan.tools.aop.annotation.Aop;
import org.voovan.tools.aop.annotation.Around;
import org.voovan.tools.aop.annotation.Before;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;

public class AopUtils {
    public static ClassPool CLASSPOOL = ClassPool.getDefault();
    public static List<CutPointInfo> CUT_POINTINFO_LIST = new ArrayList<CutPointInfo>();

    public static CtClass getCtClass(String className) throws NotFoundException {
        CtClass ctClass = null;
        ctClass = CLASSPOOL.get(className);
        ctClass.detach();
        return ctClass;
    }

    public static List<CtClass> searchClassInJavassist(String pattern, Class[] filters) throws IOException {
        String userDir = System.getProperty("user.dir");
        List<String> classPaths = TEnv.getClassPath();
        ArrayList<CtClass> clazzes = new ArrayList<CtClass>();
        for (String classPath : classPaths) {
            File classPathFile = new File(classPath);
            if (classPathFile.exists() && classPathFile.isDirectory()) {
                clazzes.addAll(AopUtils.getDirectorClass(classPathFile, pattern, filters));
                continue;
            }
            if (!classPathFile.exists() || !classPathFile.isFile() || !classPathFile.getName().endsWith(".jar")) continue;
            clazzes.addAll(AopUtils.getJarClass(classPathFile, pattern, filters));
        }
        return clazzes;
    }

    public static List<CtClass> getDirectorClass(File rootfile, String pattern, Class[] filters) throws IOException {
        if (pattern != null) {
            pattern = pattern.replace(".", File.separator);
        }
        String innerPattern = File.separator.equals("\\") ? Matcher.quoteReplacement(pattern) : pattern;
        ArrayList<CtClass> result = new ArrayList<CtClass>();
        List<File> files = TFile.scanFile(rootfile, innerPattern);
        for (File file : files) {
            String fileName = file.getCanonicalPath();
            if (!"class".equals(TFile.getFileExtension(fileName)) || TString.regexMatch(fileName, "\\$\\d\\.class") > 0) continue;
            fileName = fileName.replace(rootfile.getCanonicalPath() + File.separator, "");
            try {
                CtClass clazz = AopUtils.resourceToCtClass(fileName);
                result.add(clazz);
            }
            catch (ClassNotFoundException e) {
                Logger.warn("Try to load class[" + fileName + "] failed", e);
            }
        }
        return result;
    }

    public static List<CtClass> getJarClass(File jarFile, String pattern, Class[] filters) throws IOException {
        if (pattern != null) {
            pattern = pattern.replace(".", File.separator);
        }
        ArrayList<CtClass> result = new ArrayList<CtClass>();
        List<JarEntry> jarEntrys = TFile.scanJar(jarFile, pattern);
        for (JarEntry jarEntry : jarEntrys) {
            String fileName = jarEntry.getName();
            if (!"class".equals(TFile.getFileExtension(fileName)) || TString.regexMatch(fileName, "\\$\\d\\.class") > 0) continue;
            try {
                CtClass clazz = AopUtils.resourceToCtClass(fileName);
                result.add(clazz);
            }
            catch (Throwable e) {
                fileName = null;
            }
        }
        return result;
    }

    public static CtClass resourceToCtClass(String resourcePath) throws ClassNotFoundException {
        String className = null;
        if (resourcePath.startsWith(File.separator)) {
            resourcePath = TString.removePrefix(resourcePath);
        }
        className = TString.fastReplaceAll(resourcePath, "\\$.*\\.class$", ".class");
        className = TString.fastReplaceAll(className, ".class$", "");
        className = TString.fastReplaceAll(className, Matcher.quoteReplacement(File.separator), ".");
        try {
            return CLASSPOOL.get(className);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("load and define class " + className + " failed");
        }
    }

    public static void scanAopClass(String scanPackage) throws IOException, ClassNotFoundException {
        System.out.println("[AOP] Scan from package: " + scanPackage);
        List<CtClass> aopClasses = AopUtils.searchClassInJavassist(scanPackage, new Class[]{Aop.class});
        for (CtClass clazz : aopClasses) {
            CtMethod[] methods;
            for (CtMethod cutPointMethod : methods = clazz.getDeclaredMethods()) {
                CutPointInfo cutPointInfo;
                Before onBefore = (Before)cutPointMethod.getAnnotation(Before.class);
                After onAfter = (After)cutPointMethod.getAnnotation(After.class);
                Abnormal onAbnormal = (Abnormal)cutPointMethod.getAnnotation(Abnormal.class);
                Around onAround = (Around)cutPointMethod.getAnnotation(Around.class);
                if (onBefore != null) {
                    cutPointInfo = CutPointInfo.parse(onBefore.value());
                    cutPointInfo.setType(-1);
                    cutPointInfo.setCutPointMethod(cutPointMethod);
                    cutPointInfo.setInterceptLambda(onBefore.lambda());
                    CUT_POINTINFO_LIST.add(cutPointInfo);
                    System.out.println("[AOP] Add cutpoint: " + JSON.toJSON(cutPointInfo.getClazzName() + "@" + cutPointInfo.getMethodName()));
                }
                if (onAfter != null) {
                    cutPointInfo = CutPointInfo.parse(onAfter.value());
                    cutPointInfo.setType(1);
                    cutPointInfo.setCutPointMethod(cutPointMethod);
                    cutPointInfo.setInterceptLambda(onAfter.lambda());
                    CUT_POINTINFO_LIST.add(cutPointInfo);
                    System.out.println("[AOP] Add cutpoint: " + JSON.toJSON(cutPointInfo.getClazzName() + "@" + cutPointInfo.getMethodName()));
                }
                if (onAbnormal != null) {
                    cutPointInfo = CutPointInfo.parse(onAbnormal.value());
                    cutPointInfo.setType(2);
                    cutPointInfo.setCutPointMethod(cutPointMethod);
                    cutPointInfo.setInterceptLambda(onAbnormal.lambda());
                    CUT_POINTINFO_LIST.add(cutPointInfo);
                    System.out.println("[AOP] Add cutpoint: " + JSON.toJSON(cutPointInfo.getClazzName() + "@" + cutPointInfo.getMethodName()));
                }
                if (onAround == null) continue;
                cutPointInfo = CutPointInfo.parse(onAround.value());
                cutPointInfo.setType(3);
                cutPointInfo.setCutPointMethod(cutPointMethod);
                cutPointInfo.setInterceptLambda(onAround.lambda());
                CUT_POINTINFO_LIST.add(cutPointInfo);
                System.out.println("[AOP] Add cutpoint: " + JSON.toJSON(cutPointInfo.getClazzName() + "@" + cutPointInfo.getMethodName()));
            }
        }
    }
}

