/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.hashwheeltimer.HashWheelTask;

public class TProperties {
    private static ConcurrentHashMap<File, Properties> propertiesFile = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Properties> propertiesName = new ConcurrentHashMap();
    private static ConcurrentHashMap<File, Long> propertiesWatcher = new ConcurrentHashMap();

    public static Properties getProperties(File file) {
        try {
            Properties properties = propertiesFile.get(file);
            if (properties == null) {
                Properties properites = new Properties();
                String content = null;
                if (!file.getPath().contains("!" + File.separator)) {
                    content = new String(TFile.loadFile(file));
                } else {
                    String filePath = file.getPath();
                    String resourcePath = filePath.substring(filePath.indexOf("!" + File.separator) + 2, filePath.length());
                    content = new String(TFile.loadResource(resourcePath));
                }
                properites.load(new StringReader(content));
                propertiesWatcher.put(file, file.lastModified());
                propertiesFile.put(file, properites);
                System.out.println("[PROPERTIES] Load Properties file: " + file.getPath());
            }
            return propertiesFile.get(file);
        }
        catch (IOException e) {
            System.out.println("Get properites file failed. File:" + file.getAbsolutePath() + "-->" + e.getMessage());
            return null;
        }
    }

    public static Properties getProperties(String fileName) {
        Properties properties;
        File file = null;
        String configFileNameWithEnv = null;
        String configFileName = "";
        if (!fileName.contains(".properties")) {
            String envName = TEnv.getEnvName();
            envName = envName == null ? "" : "-" + envName;
            configFileNameWithEnv = fileName + envName + ".properties";
            configFileName = fileName + ".properties";
        }
        if ((properties = propertiesName.get(configFileNameWithEnv)) == null) {
            properties = propertiesName.get(configFileName);
        }
        if (properties == null) {
            File configFile = TFile.getResourceFile(configFileName);
            File configFileWithEnv = TFile.getResourceFile(configFileNameWithEnv);
            if (configFileWithEnv != null) {
                file = configFileWithEnv;
                fileName = configFileNameWithEnv;
            } else if (configFile != null) {
                file = configFile;
                fileName = configFileName;
            }
            if (file != null) {
                properties = TProperties.getProperties(file);
                propertiesName.put(fileName, properties);
                return properties;
            }
            System.out.println("Get properites file failed. File:" + file.getName());
            return null;
        }
        return properties;
    }

    public static String getString(File file, String name, String defaultValue) {
        Properties properites = TProperties.getProperties(file);
        String value = properites.getProperty(name);
        return TString.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static String getString(File file, String name) {
        return TProperties.getString(file, name, null);
    }

    public static int getInt(File file, String name, Integer defaultValue) {
        defaultValue = defaultValue == null ? 0 : defaultValue;
        String value = TProperties.getString(file, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Integer.valueOf(value.trim());
    }

    public static int getInt(File file, String name) {
        return TProperties.getInt(file, name, null);
    }

    public static float getFloat(File file, String name, Float defaultValue) {
        defaultValue = Float.valueOf(defaultValue == null ? 0.0f : defaultValue.floatValue());
        String value = TProperties.getString(file, name);
        return (TString.isNullOrEmpty(value) ? defaultValue : Float.valueOf(value.trim())).floatValue();
    }

    public static float getFloat(File file, String name) {
        return TProperties.getFloat(file, name, null);
    }

    public static double getDouble(File file, String name, Double defaultValue) {
        defaultValue = defaultValue == null ? 0.0 : defaultValue;
        String value = TProperties.getString(file, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Double.valueOf(value.trim());
    }

    public static double getDouble(File file, String name) {
        return TProperties.getDouble(file, name, null);
    }

    public static boolean getBoolean(File file, String name, Boolean defaultValue) {
        defaultValue = defaultValue == null ? false : defaultValue;
        String value = TProperties.getString(file, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Boolean.valueOf(value.trim());
    }

    public static boolean defaultValue(File file, String name) {
        return TProperties.getBoolean(file, name, null);
    }

    public static void setString(File file, String name, String value) throws IOException {
        Properties properites = TProperties.getProperties(file);
        properites.setProperty(name, value);
        properites.store(new FileOutputStream(file), null);
    }

    public static String getString(String fileName, String name, String defaultValue) {
        Properties properites = TProperties.getProperties(fileName);
        String value = properites.getProperty(name);
        return TString.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static String getString(String fileName, String name) {
        return TProperties.getString(fileName, name, null);
    }

    public static int getInt(String fileName, String name, Integer defaultValue) {
        defaultValue = defaultValue == null ? 0 : defaultValue;
        String value = TProperties.getString(fileName, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Integer.valueOf(value.trim());
    }

    public static int getInt(String fileName, String name) {
        return TProperties.getInt(fileName, name, null);
    }

    public static float getFloat(String fileName, String name, Float defaultValue) {
        defaultValue = Float.valueOf(defaultValue == null ? 0.0f : defaultValue.floatValue());
        String value = TProperties.getString(fileName, name);
        return (TString.isNullOrEmpty(value) ? defaultValue : Float.valueOf(value.trim())).floatValue();
    }

    public static float getFloat(String fileName, String name) {
        return TProperties.getFloat(fileName, name, null);
    }

    public static double getDouble(String fileName, String name, Double defaultValue) {
        defaultValue = defaultValue == null ? 0.0 : defaultValue;
        String value = TProperties.getString(fileName, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Double.valueOf(value.trim());
    }

    public static double getDouble(String fileName, String name) {
        return TProperties.getDouble(fileName, name, null);
    }

    public static boolean getBoolean(String fileName, String name, Boolean defaultValue) {
        defaultValue = defaultValue == null ? false : defaultValue;
        String value = TProperties.getString(fileName, name);
        return TString.isNullOrEmpty(value) ? defaultValue : Boolean.valueOf(value.trim());
    }

    public static boolean getBoolean(String fileName, String name) {
        return TProperties.getBoolean(fileName, name, null);
    }

    public void clear() {
        propertiesName.clear();
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                Iterator iterator = propertiesWatcher.entrySet().iterator();
                while (iterator.hasNext()) {
                    long lastFileTime;
                    Map.Entry entry = iterator.next();
                    File file = (File)entry.getKey();
                    long lastWatchTime = (Long)entry.getValue();
                    if (lastWatchTime == (lastFileTime = file.lastModified())) continue;
                    propertiesFile.remove(file);
                    propertiesName.remove(file.getName());
                    iterator.remove();
                }
            }
        }, 5, true);
    }
}

