/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ThreadPoolExecutor;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TStream;
import org.voovan.tools.TString;

public class TPerformance {
    private static OperatingSystemMXBean osmxb = ManagementFactory.getOperatingSystemMXBean();
    private static List<String> LOCAL_IP_ADDRESSES = new ArrayList<String>();

    public static double getSystemLoadAverage() {
        return osmxb.getSystemLoadAverage();
    }

    public static int getProcessorCount() {
        return osmxb.getAvailableProcessors();
    }

    public static List<String> getLocalIpAddrs() {
        if (LOCAL_IP_ADDRESSES.size() == 0) {
            try {
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    if (!ni.getInetAddresses().hasMoreElements()) continue;
                    ip = ni.getInetAddresses().nextElement();
                    LOCAL_IP_ADDRESSES.add(ip.getHostAddress());
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        return LOCAL_IP_ADDRESSES;
    }

    public static double cpuPerCoreLoadAvg() {
        double perCoreLoadAvg = osmxb.getSystemLoadAverage() / (double)osmxb.getAvailableProcessors();
        BigDecimal bg = new BigDecimal(perCoreLoadAvg);
        perCoreLoadAvg = bg.setScale(2, 4).doubleValue();
        return perCoreLoadAvg;
    }

    public static double getJVMMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        double memoryUsage = 1.0 - ((double)runtime.freeMemory() + (double)(runtime.maxMemory() - runtime.totalMemory())) / (double)runtime.maxMemory();
        BigDecimal bg = new BigDecimal(memoryUsage);
        memoryUsage = bg.setScale(2, 4).doubleValue();
        return memoryUsage;
    }

    public static long getJVMMemoryInfo(MEMTYPE memType) {
        if (memType == MEMTYPE.NOHEAP_INIT) {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getInit();
        }
        if (memType == MEMTYPE.NOHEAP_MAX) {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getMax();
        }
        if (memType == MEMTYPE.NOHEAP_USAGE) {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
        }
        if (memType == MEMTYPE.NOHEAP_COMMIT) {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getCommitted();
        }
        if (memType == MEMTYPE.HEAP_INIT) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getInit();
        }
        if (memType == MEMTYPE.HEAP_MAX) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        }
        if (memType == MEMTYPE.HEAP_USAGE) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        }
        if (memType == MEMTYPE.HEAP_COMMIT) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted();
        }
        throw new RuntimeException("getMemoryInfo function arg error!");
    }

    public static MemoryInfo getJVMMemoryInfo() {
        MemoryInfo memoryInfo = new MemoryInfo();
        memoryInfo.setHeapInit(TPerformance.getJVMMemoryInfo(MEMTYPE.HEAP_INIT));
        memoryInfo.setHeapUsage(TPerformance.getJVMMemoryInfo(MEMTYPE.HEAP_USAGE));
        memoryInfo.setHeapCommit(TPerformance.getJVMMemoryInfo(MEMTYPE.HEAP_COMMIT));
        memoryInfo.setHeapMax(TPerformance.getJVMMemoryInfo(MEMTYPE.HEAP_MAX));
        memoryInfo.setNoHeapInit(TPerformance.getJVMMemoryInfo(MEMTYPE.NOHEAP_INIT));
        memoryInfo.setNoHeapUsage(TPerformance.getJVMMemoryInfo(MEMTYPE.NOHEAP_USAGE));
        memoryInfo.setNoHeapCommit(TPerformance.getJVMMemoryInfo(MEMTYPE.NOHEAP_COMMIT));
        memoryInfo.setNoHeapMax(TPerformance.getJVMMemoryInfo(MEMTYPE.NOHEAP_MAX));
        memoryInfo.setFree(Runtime.getRuntime().freeMemory());
        memoryInfo.setTotal(Runtime.getRuntime().totalMemory());
        memoryInfo.setMax(Runtime.getRuntime().maxMemory());
        return memoryInfo;
    }

    public static Map<String, String> getJVMGCInfo(long pid) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        InputStream processInputStream = TEnv.createSysProcess("jstat -gcutil " + pid, null, (File)null).getInputStream();
        String console = new String(TStream.readAll(processInputStream));
        String[] consoleLines = console.split(System.lineSeparator());
        String[] titleLine = consoleLines[0].trim().split("\\s+");
        String[] dataLine = consoleLines[1].trim().split("\\s+");
        for (int i = 0; i < titleLine.length; ++i) {
            result.put(titleLine[i], dataLine[i]);
        }
        return result;
    }

    public static Map<String, String> getJVMGCInfo() throws IOException {
        return TPerformance.getJVMGCInfo(TEnv.getCurrentPID());
    }

    public static Map<String, ObjectInfo> getJVMObjectInfo(long pid, String regex, Integer headCount) throws IOException {
        LinkedHashMap<String, ObjectInfo> result = new LinkedHashMap<String, ObjectInfo>();
        InputStream processInputStream = TEnv.createSysProcess("jmap -histo " + pid, null, (File)null).getInputStream();
        String console = new String(TStream.readAll(processInputStream));
        String[] consoleLines = console.split(System.lineSeparator());
        headCount = headCount < 0 ? Integer.valueOf(consoleLines.length) : Integer.valueOf(headCount + 3);
        for (int lineCount = 3; lineCount < headCount; ++lineCount) {
            String lineContent = consoleLines[lineCount];
            long count = Long.parseLong(lineContent.substring(5, 19).trim());
            long size = Long.parseLong(lineContent.substring(19, 34).trim());
            String name = lineContent.substring(34, lineContent.length()).trim();
            if (name.isEmpty() || TString.regexMatch(name, regex) <= 0) continue;
            ObjectInfo objectInfo = new ObjectInfo(name, size, count);
            result.put(name, objectInfo);
        }
        return result;
    }

    public static Map<String, ObjectInfo> getJVMObjectInfo(String regex, int headCount) {
        Map<String, ObjectInfo> result;
        if (regex == null) {
            regex = ".*";
        }
        try {
            result = TPerformance.getJVMObjectInfo(TEnv.getCurrentPID(), regex, headCount);
        }
        catch (IOException e) {
            result = new Hashtable<String, ObjectInfo>();
        }
        return result;
    }

    public static Map<String, Object> getThreadPoolInfo() {
        HashMap<String, Object> threadPoolInfo = new HashMap<String, Object>();
        ThreadPoolExecutor threadPoolInstance = Global.getThreadPool();
        threadPoolInfo.put("ActiveCount", threadPoolInstance.getActiveCount());
        threadPoolInfo.put("CorePoolSize", threadPoolInstance.getCorePoolSize());
        threadPoolInfo.put("FinishedTaskCount", threadPoolInstance.getCompletedTaskCount());
        threadPoolInfo.put("TaskCount", threadPoolInstance.getTaskCount());
        threadPoolInfo.put("QueueSize", threadPoolInstance.getQueue().size());
        return threadPoolInfo;
    }

    public static List<Map<String, Object>> getThreadDetail(String state, boolean withStack) {
        ArrayList<Map<String, Object>> threadDetailList = new ArrayList<Map<String, Object>>();
        for (Thread thread : TEnv.getThreads()) {
            if (state != null && !thread.getState().name().equals(state)) continue;
            Hashtable<String, Object> threadDetail = new Hashtable<String, Object>();
            threadDetail.put("Name", thread.getName());
            threadDetail.put("Id", thread.getId());
            threadDetail.put("Priority", thread.getPriority());
            threadDetail.put("ThreadGroup", thread.getThreadGroup().getName());
            if (withStack) {
                threadDetail.put("StackTrace", TEnv.getStackElementsMessage(thread.getStackTrace()));
            }
            threadDetail.put("State", thread.getState().name());
            threadDetailList.add(threadDetail);
        }
        return threadDetailList;
    }

    public static Map<String, Object> getProcessorInfo() {
        Hashtable<String, Object> processInfo = new Hashtable<String, Object>();
        processInfo.put("ProcessorCount", TPerformance.getProcessorCount());
        processInfo.put("SystemLoadAverage", TPerformance.getSystemLoadAverage());
        return processInfo;
    }

    public static Map<String, Object> getJVMInfo() {
        Hashtable<String, Object> jvmInfo = new Hashtable<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            jvmInfo.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return jvmInfo;
    }

    public static Map<String, Integer> getSysMemInfo() throws IOException, InterruptedException {
        if (TEnv.OS_NAME.toLowerCase().contains("linux")) {
            try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                String lineStr = null;
                StringTokenizer token = null;
                while ((lineStr = bufferedReader.readLine()) != null) {
                    token = new StringTokenizer(lineStr);
                    if (!token.hasMoreTokens()) continue;
                    String tokenStr = token.nextToken();
                    if (!token.hasMoreTokens()) continue;
                    if (tokenStr.equalsIgnoreCase("MemTotal:")) {
                        result.put("MemTotal", Integer.parseInt(token.nextToken()) / 1024);
                        continue;
                    }
                    if (tokenStr.equalsIgnoreCase("MemFree:")) {
                        result.put("MemFree", Integer.parseInt(token.nextToken()) / 1024);
                        continue;
                    }
                    if (tokenStr.equalsIgnoreCase("MemAvailable:")) {
                        result.put("MemAvailable", Integer.parseInt(token.nextToken()) / 1024);
                        continue;
                    }
                    if (tokenStr.equalsIgnoreCase("SwapTotal:")) {
                        result.put("SwapTotal", Integer.parseInt(token.nextToken()) / 1024);
                        continue;
                    }
                    if (!tokenStr.equalsIgnoreCase("SwapFree:")) continue;
                    result.put("SwapFree", Integer.parseInt(token.nextToken()) / 1024);
                }
                HashMap<String, Integer> hashMap = result;
                return hashMap;
            }
        }
        return null;
    }

    public static Map<String, Integer> getSysCpuInfo() throws IOException, InterruptedException {
        if (TEnv.OS_NAME.toLowerCase().contains("linux")) {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            try (FileInputStream fileInputStream = new FileInputStream("/proc/stat");){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                StringTokenizer token = new StringTokenizer(bufferedReader.readLine());
                token.nextToken();
                result.put("User", Integer.parseInt(token.nextToken()));
                result.put("Nice", Integer.parseInt(token.nextToken()));
                result.put("Sys", Integer.parseInt(token.nextToken()));
                result.put("Idle", Integer.parseInt(token.nextToken()));
                HashMap<String, Integer> hashMap = result;
                return hashMap;
            }
        }
        return null;
    }

    public static class MemoryInfo {
        private long heapInit;
        private long heapUsage;
        private long heapMax;
        private long heapCommit;
        private long noHeapInit;
        private long noHeapUsage;
        private long noHeapMax;
        private long noHeapCommit;
        private long free;
        private long max;
        private long total;

        public long getFree() {
            return this.free;
        }

        public void setFree(long free) {
            this.free = free;
        }

        public long getMax() {
            return this.max;
        }

        public void setMax(long max) {
            this.max = max;
        }

        public long getTotal() {
            return this.total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public long getHeapInit() {
            return this.heapInit;
        }

        public void setHeapInit(long heapInit) {
            this.heapInit = heapInit;
        }

        public long getHeapUsage() {
            return this.heapUsage;
        }

        public void setHeapUsage(long heapUsage) {
            this.heapUsage = heapUsage;
        }

        public long getHeapMax() {
            return this.heapMax;
        }

        public void setHeapMax(long heapMax) {
            this.heapMax = heapMax;
        }

        public long getHeapCommit() {
            return this.heapCommit;
        }

        public void setHeapCommit(long heapCommit) {
            this.heapCommit = heapCommit;
        }

        public long getNoHeapInit() {
            return this.noHeapInit;
        }

        public void setNoHeapInit(long noHeapInit) {
            this.noHeapInit = noHeapInit;
        }

        public long getNoHeapUsage() {
            return this.noHeapUsage;
        }

        public void setNoHeapUsage(long noHeapUsage) {
            this.noHeapUsage = noHeapUsage;
        }

        public long getNoHeapMax() {
            return this.noHeapMax;
        }

        public void setNoHeapMax(long noHeapMax) {
            this.noHeapMax = noHeapMax;
        }

        public long getNoHeapCommit() {
            return this.noHeapCommit;
        }

        public void setNoHeapCommit(long noHeapCommit) {
            this.noHeapCommit = noHeapCommit;
        }
    }

    public static class ObjectInfo {
        private String name;
        private long size;
        private long count;

        public ObjectInfo(String name, long size, long count) {
            this.name = name;
            this.size = size;
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }

    public static enum MEMTYPE {
        NOHEAP_INIT,
        HEAP_INIT,
        NOHEAP_MAX,
        HEAP_MAX,
        NOHEAP_USAGE,
        HEAP_USAGE,
        NOHEAP_COMMIT,
        HEAP_COMMIT;

    }
}

