/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import org.voovan.tools.TEnv;
import org.voovan.tools.TStream;
import org.voovan.tools.TString;
import org.voovan.tools.log.Logger;

public class TFile {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean fileExists(String fullPath) {
        if (fullPath.contains("!")) {
            fullPath = fullPath.substring(0, fullPath.indexOf("!"));
        }
        return new File(fullPath).exists();
    }

    public static String assemblyPath(Object ... pathParts) {
        StringBuilder result = new StringBuilder();
        for (Object pathPart : pathParts) {
            result.append(pathPart.toString());
            if (pathPart.toString().endsWith(File.separator)) continue;
            result.append(File.separator);
        }
        return TString.removeSuffix(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(File file) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            long fileSize;
            long l = fileSize = randomAccessFile.length();
            return l;
        }
    }

    public static byte[] loadFileFromSysPath(String filePath) {
        byte[] fileContent = null;
        fileContent = TFile.loadFile(new File(filePath));
        return fileContent;
    }

    public static byte[] loadFileFromSysPath(String filePath, long beginPos, long endPos) {
        byte[] fileContent = null;
        fileContent = TFile.loadFile(new File(filePath), beginPos, endPos);
        return fileContent;
    }

    public static byte[] loadFileFromContextPath(String filePath, long beginPos, long endPos) {
        String spliter = filePath.startsWith(File.separator) ? "" : File.separator;
        String fullFilePath = TFile.getContextPath() + spliter + filePath;
        return TFile.loadFileFromSysPath(fullFilePath, beginPos, endPos);
    }

    public static byte[] loadFileFromContextPath(String filePath) {
        String spliter = filePath.startsWith(File.separator) ? "" : File.separator;
        String fullFilePath = TFile.getContextPath() + spliter + filePath;
        return TFile.loadFileFromSysPath(fullFilePath);
    }

    public static File getResourceFile(String resourcePath) {
        URL url = TEnv.class.getClassLoader().getResource(resourcePath);
        if (url != null) {
            File file = new File(url.getFile());
            return file;
        }
        return null;
    }

    public static byte[] loadResource(String resourcePath) {
        try {
            resourcePath = URLDecoder.decode(resourcePath, "utf-8");
            InputStream inputStream = TEnv.class.getClassLoader().getResourceAsStream(resourcePath);
            return TStream.readAll(inputStream);
        }
        catch (IOException e) {
            Logger.error("Load resource " + resourcePath + " failed", e);
            return null;
        }
    }

    public static byte[] loadFile(File file) {
        return TFile.loadFile(file, 0L, -1L);
    }

    public static byte[] loadFile(File file, long beginPos, long endPos) {
        try {
            if (!file.exists()) {
                return null;
            }
            long fileSize = file.length();
            if (endPos > fileSize) {
                endPos = (int)fileSize;
            }
            if (beginPos < 0L) {
                return null;
            }
            if (beginPos >= fileSize) {
                return null;
            }
            if (beginPos == endPos) {
                return null;
            }
            long loadLength = 0L;
            loadLength = endPos < 0L ? (long)((int)fileSize) - beginPos + 1L : endPos - beginPos + 1L;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] fileBytes = new byte[(int)loadLength - 1];
            randomAccessFile.seek(beginPos);
            randomAccessFile.read(fileBytes);
            randomAccessFile.close();
            return fileBytes;
        }
        catch (IOException e) {
            Logger.error("Load file error: " + file.getAbsolutePath(), e);
            return null;
        }
    }

    public static byte[] loadFileLastLines(File file, int lastLineNum) throws IOException {
        try (RandomAccessFile randomAccessFile = null;){
            randomAccessFile = new RandomAccessFile(file, "r");
            long fileLength = randomAccessFile.length() - 1L;
            randomAccessFile.seek(fileLength);
            int rowCount = 0;
            while (randomAccessFile.getFilePointer() != 0L) {
                randomAccessFile.seek(fileLength);
                byte readByte = randomAccessFile.readByte();
                if (readByte == 10) {
                    ++rowCount;
                }
                if (fileLength == 0L || lastLineNum == rowCount) {
                    int byteCount;
                    byte[] byteContent;
                    int readSize;
                    if (fileLength == 0L) {
                        randomAccessFile.seek(0L);
                    }
                    if ((readSize = randomAccessFile.read(byteContent = new byte[byteCount = (int)(randomAccessFile.length() - fileLength)])) > 0) {
                        byte[] byArray = byteContent;
                        return byArray;
                    }
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                --fileLength;
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(File file, boolean append, byte[] contents, int offset, int length) throws IOException {
        if (!append && file.exists()) {
            file.delete();
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");){
            if (append) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile.write(contents, offset, length);
            boolean bl = true;
            return bl;
        }
    }

    public static boolean writeFile(File file, boolean append, byte[] contents) throws IOException {
        return TFile.writeFile(file, append, contents, 0, contents.length);
    }

    public static boolean writeFile(File file, byte[] contents, int offset, int length) throws IOException {
        return TFile.writeFile(file, true, contents, 0, contents.length);
    }

    public static boolean writeFile(File file, byte[] contents) throws IOException {
        return TFile.writeFile(file, true, contents, 0, contents.length);
    }

    public static List<File> scanFile(File file, String pattern) {
        pattern = pattern.isEmpty() ? null : pattern;
        String innerPattern = File.separator.equals("\\") ? Matcher.quoteReplacement(pattern) : pattern;
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                result.addAll(TFile.scanFile(subFile, pattern));
            }
        } else if (innerPattern == null || TString.regexMatch(file.getPath(), innerPattern) > 0) {
            result.add(file);
        }
        return result;
    }

    public static List<JarEntry> scanJar(File file, String pattern) throws IOException {
        pattern = pattern.isEmpty() ? null : pattern;
        String innerPattern = File.separator.equals("\\") ? Matcher.quoteReplacement(pattern) : pattern;
        ArrayList<JarEntry> result = new ArrayList<JarEntry>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        while (jarEntrys.hasMoreElements()) {
            JarEntry jarEntry = jarEntrys.nextElement();
            String fileName = jarEntry.getName();
            if (innerPattern != null && TString.regexMatch(fileName, innerPattern) <= 0) continue;
            result.add(jarEntry);
        }
        jarFile.close();
        return result;
    }

    public static String getSystemPath(String relativePath) {
        String spliter = relativePath.startsWith(File.separator) ? "" : File.separator;
        return TFile.getContextPath() + spliter + relativePath;
    }

    public static String getContextPath() {
        return System.getProperty("user.dir");
    }

    public static String getTemporaryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getFileExtension(String filePath) {
        try {
            if (filePath.lastIndexOf(".") > 0) {
                return filePath.substring(filePath.lastIndexOf(".") + 1);
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String getFileDirectory(String filePath) {
        try {
            if (TFile.getFileExtension(filePath) != null) {
                return filePath.substring(0, filePath.lastIndexOf(File.separator) + 1);
            }
            return filePath;
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public static String getFileName(String filePath) {
        try {
            return filePath.substring(filePath.lastIndexOf(File.separator) + 1, filePath.length());
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public static boolean moveFile(File src, File dest) throws IOException {
        new File(TFile.getFileDirectory(dest.getCanonicalPath())).mkdirs();
        if (src.renameTo(dest)) {
            return true;
        }
        return TFile.copyFile(src, dest);
    }

    public static boolean mkdir(String dirPath) {
        File dir = new File(TFile.getFileDirectory(dirPath));
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dest) {
        RandomAccessFile srcFileAccess = null;
        RandomAccessFile destFileAccess = null;
        try {
            int bufferSize = 524288;
            byte[] buffer = new byte[bufferSize];
            long srcLength = src.length();
            srcFileAccess = new RandomAccessFile(src, "r");
            destFileAccess = new RandomAccessFile(dest, "rwd");
            while (srcLength > 0L) {
                int loadSize = srcLength >= (long)bufferSize ? bufferSize : (int)srcLength;
                loadSize = srcFileAccess.read(buffer, 0, loadSize);
                destFileAccess.write(buffer, 0, loadSize);
                if ((srcLength -= (long)loadSize) != 0L) continue;
                if (!dest.exists()) {
                    boolean bl = false;
                    return bl;
                }
                dest.setLastModified(src.lastModified());
                src.delete();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                srcFileAccess.close();
                destFileAccess.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    TFile.deleteFile(files[i]);
                }
                file.delete();
            }
        }
    }

    public static void deleteFile(String filePath) {
        TFile.deleteFile(new File(filePath));
    }
}

