/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.voovan.tools.exception.ParseException;

public class TDateTime {
    public static final String STANDER_DATE_TEMPLATE = "yyyy-MM-dd";
    public static final String STANDER_TIME_TEMPLATE = "HH:mm:ss";
    public static final String STANDER_DATETIME_TEMPLATE = "yyyy-MM-dd HH:mm:ss";
    public static final String INTERNTTION_DATETIME_TEMPLATE = "EEE, dd MMM yyyy HH:mm:ss z";

    public static String now() {
        return TDateTime.format(new Date(), STANDER_DATETIME_TEMPLATE);
    }

    public static String now(String format) {
        return TDateTime.format(new Date(), format);
    }

    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDER_DATETIME_TEMPLATE);
        return simpleDateFormat.format(date);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static String format(Date date, String format, Locale local) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, local);
        return simpleDateFormat.format(date);
    }

    public static String format(Date date, String format, String timeZone, Locale local) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, local);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        return simpleDateFormat.format(date);
    }

    public static String formatToGMT(Date date) {
        return TDateTime.format(date, INTERNTTION_DATETIME_TEMPLATE, "GMT", Locale.ENGLISH);
    }

    public static Date parse(String source) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDER_DATETIME_TEMPLATE);
        return TDateTime.simpleDateFormatParse(simpleDateFormat, source);
    }

    public static Date parse(String source, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return TDateTime.simpleDateFormatParse(simpleDateFormat, source);
    }

    public static Date parse(String source, String format, Locale local) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return TDateTime.simpleDateFormatParse(simpleDateFormat, source);
    }

    public static Date parse(String source, String format, String timeZone, Locale local) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, local);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        return TDateTime.simpleDateFormatParse(simpleDateFormat, source);
    }

    private static Date simpleDateFormatParse(SimpleDateFormat simpleDateFormat, String source) {
        try {
            return simpleDateFormat.parse(source);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e);
        }
    }

    public static Date parseToGMT(String source) {
        return TDateTime.parse(source, INTERNTTION_DATETIME_TEMPLATE, "GMT", Locale.ENGLISH);
    }

    public static Date add(Date date, long millis) {
        return new Date(date.getTime() + millis);
    }

    public static String add(String time, long millis, String format) throws java.text.ParseException {
        Date tmpDate = TDateTime.parse(time, format);
        Date resultDate = TDateTime.add(tmpDate, millis);
        return TDateTime.format(resultDate, format);
    }

    public static int getDateAtom(Date date, int type) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        return calendar.get(type);
    }
}

