/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.nio.charset.Charset;

public class TByte {
    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getBytes(boolean data) {
        return TByte.getBytes(data ? 1 : 0);
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return TByte.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return TByte.getBytes(intBits);
    }

    public static byte[] getBytes(String data, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return data.getBytes(charset);
    }

    public static byte[] getBytes(String data) {
        return TByte.getBytes(data, "UTF-8");
    }

    public static short getShort(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static char getChar(byte[] bytes) {
        return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static boolean getBoolean(byte[] bytes) {
        return TByte.getInt(bytes) == 1;
    }

    public static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(TByte.getInt(bytes));
    }

    public static double getDouble(byte[] bytes) {
        long l = TByte.getLong(bytes);
        return Double.longBitsToDouble(l);
    }

    public static String getString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    public static String getString(byte[] bytes) {
        return TByte.getString(bytes, "UTF-8");
    }

    public static byte[] toBytes(Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return TByte.getBytes((Integer)obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return TByte.getBytes(((Float)obj).floatValue());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return TByte.getBytes((Double)obj);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return TByte.getBytes((Boolean)obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return TByte.getBytes((Long)obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return TByte.getBytes((Short)obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return TByte.getBytes(((Byte)obj).byteValue());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return TByte.getBytes(((Character)obj).charValue());
        }
        if (clazz == String.class) {
            return TByte.getBytes((String)obj);
        }
        if (clazz == byte[].class) {
            return (byte[])obj;
        }
        return null;
    }

    public static Object toObject(byte[] bytes, Class clazz) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return TByte.getInt(bytes);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(TByte.getFloat(bytes));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return TByte.getDouble(bytes);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return TByte.getBoolean(bytes);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return TByte.getLong(bytes);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return TByte.getShort(bytes);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return TByte.getShort(bytes);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(TByte.getChar(bytes));
        }
        if (clazz == String.class) {
            return TByte.getString(bytes);
        }
        if (clazz == byte[].class) {
            return bytes;
        }
        return null;
    }

    public static byte[] byteArrayConcat(byte[] firstBytes, int firstBytesLength, byte[] lastBytes, int lastBytesLength) {
        if (lastBytes.length == 0) {
            return firstBytes;
        }
        byte[] target = new byte[firstBytesLength + lastBytesLength];
        System.arraycopy(firstBytes, 0, target, 0, firstBytesLength);
        System.arraycopy(lastBytes, 0, target, firstBytes.length, lastBytesLength);
        return target;
    }

    public static int byteIndexOf(byte[] source, byte mark) {
        for (int i = source.length - 1; i >= 0; --i) {
            if (source[i] != mark) continue;
            return i;
        }
        return -1;
    }

    public static int byteArrayIndexOf(byte[] source, byte[] mark) {
        if (source.length == 0) {
            return -1;
        }
        if (source.length < mark.length) {
            return -1;
        }
        int index = -1;
        int i = 0;
        int j = 0;
        while (i <= source.length - mark.length + j) {
            if (source[i] != mark[j]) {
                if (i == source.length - mark.length + j) break;
                int pos = TByte.byteIndexOf(mark, source[i + mark.length - j]);
                if (pos == -1) {
                    i = i + mark.length + 1 - j;
                    j = 0;
                    continue;
                }
                i = i + mark.length - pos - j;
                j = 0;
                continue;
            }
            if (j == mark.length - 1) {
                i = i - j + 1;
                j = 0;
                index = i - j - 1;
                break;
            }
            ++i;
            ++j;
        }
        return index;
    }

    public static boolean byteArrayStartWith(byte[] byte1, byte[] byte2) {
        for (int i = 0; i < byte2.length; ++i) {
            if (byte1[i] < byte2[i]) {
                return false;
            }
            if (byte1[i] <= byte2[i]) continue;
            return false;
        }
        return true;
    }
}

