/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity4.auth;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.extras.springsecurity4.auth.AuthUtils;
import org.thymeleaf.util.Validate;

public final class Authorization {
    private final IExpressionContext context;
    private final Authentication authentication;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;

    public Authorization(IExpressionContext context, Authentication authentication, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.context = context;
        this.authentication = authentication;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
    }

    public IExpressionContext getContext() {
        return this.context;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean expr(String expression) {
        return this.expression(expression);
    }

    public boolean expression(String expression) {
        Validate.notEmpty((String)expression, (String)"Access expression cannot be null");
        return AuthUtils.authorizeUsingAccessExpression(this.context, expression, this.authentication, this.request, this.response, this.servletContext);
    }

    public boolean url(String url) {
        return this.url("GET", url);
    }

    public boolean url(String method, String url) {
        Validate.notEmpty((String)url, (String)"URL cannot be null");
        return AuthUtils.authorizeUsingUrlCheck(url, method, this.authentication, this.request, this.servletContext);
    }
}

