/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.java8time.util;

import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.java8time.util.TemporalObjects;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class TemporalFormattingUtils {
    private static final DateTimeFormatter ISO8601_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");
    private final Locale locale;
    private final ZoneId defaultZoneId;

    public TemporalFormattingUtils(Locale locale, ZoneId defaultZoneId) {
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        Validate.notNull((Object)defaultZoneId, (String)"ZoneId cannot be null");
        this.locale = locale;
        this.defaultZoneId = defaultZoneId;
    }

    public String format(Object target) {
        Validate.notNull((Object)target, (String)"Cannot apply format on null");
        return this.formatDate(target);
    }

    public String format(Object target, Locale locale) {
        Validate.notNull((Object)target, (String)"Cannot apply format on null");
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        return this.formatDate(target, null, locale);
    }

    public String format(Object target, String pattern) {
        return this.format(target, pattern, null);
    }

    public String format(Object target, String pattern, Locale locale) {
        Validate.notNull((Object)target, (String)"Cannot apply format on null");
        Validate.notEmpty((String)pattern, (String)"Pattern cannot be null or empty");
        return this.formatDate(target, pattern, locale);
    }

    public Integer day(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve day from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.DAY_OF_MONTH);
    }

    public Integer month(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve month from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.MONTH_OF_YEAR);
    }

    public String monthName(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve month name from null");
        return this.format(target, "MMMM");
    }

    public String monthNameShort(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve month name short from null");
        return this.format(target, "MMM");
    }

    public Integer year(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve year from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.YEAR);
    }

    public Integer dayOfWeek(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve day of week from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.DAY_OF_WEEK);
    }

    public String dayOfWeekName(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve day of week name from null");
        return this.format(target, "EEEE");
    }

    public String dayOfWeekNameShort(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve day of week name shortfrom null");
        return this.format(target, "EEE");
    }

    public Integer hour(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve hour from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.HOUR_OF_DAY);
    }

    public Integer minute(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve hour from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.MINUTE_OF_HOUR);
    }

    public Integer second(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve hour from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.SECOND_OF_MINUTE);
    }

    public Integer nanosecond(Object target) {
        Validate.notNull((Object)target, (String)"Cannot retrieve hour from null");
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.NANO_OF_SECOND);
    }

    public String formatISO(Object target) {
        Validate.notNull((Object)target, (String)"Cannot apply format on null");
        if (target instanceof TemporalAccessor) {
            ChronoZonedDateTime time = TemporalObjects.zonedTime(target, this.defaultZoneId);
            return ISO8601_DATE_TIME_FORMATTER.withLocale(this.locale).format(time);
        }
        throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a date");
    }

    private String formatDate(Object target) {
        return this.formatDate(target, null, null);
    }

    private String formatDate(Object target, String pattern, Locale localeOverride) {
        Locale formattingLocale = localeOverride != null ? localeOverride : this.locale;
        try {
            Validate.notNull((Object)target, (String)"Cannot apply format on null");
            if (StringUtils.isEmptyOrWhitespace((String)pattern)) {
                DateTimeFormatter formatter = TemporalObjects.formatterFor(target, formattingLocale);
                return formatter.format(TemporalObjects.temporal(target));
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, formattingLocale);
            return formatter.format(TemporalObjects.temporal(target));
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting date for locale " + formattingLocale, (Throwable)e);
        }
    }
}

