/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.hutool.ZipUtil;

public class HttpGzipUtils {
    private static Logger log = LoggerFactory.getLogger(HttpGzipUtils.class);

    public static void gzip(HttpRequest request, HttpResponse response) {
        if (response == null) {
            return;
        }
        if (response.isHasGzipped()) {
            return;
        }
        if (request.getIsSupportGzip().booleanValue()) {
            HttpGzipUtils.gzip(response);
        } else {
            log.warn("{}, \u4e0d\u652f\u6301gzip, {}", (Object)request.getClientIp(), (Object)request.getHeader("user-agent"));
        }
    }

    public static void gzip(HttpResponse response) {
        byte[] bs2;
        if (response == null) {
            return;
        }
        if (response.isHasGzipped()) {
            return;
        }
        byte[] bs = response.getBody();
        if (bs != null && bs.length >= 300 && (bs2 = ZipUtil.gzip((byte[])bs)).length < bs.length) {
            response.setBody(bs2);
            response.setHasGzipped(true);
            response.addHeader(HeaderName.Content_Encoding, HeaderValue.Content_Encoding.gzip);
        }
    }

    private HttpGzipUtils() {
    }
}

