/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V, E> {
    private final Map<K, V> map;
    private final Lock rl;
    private final Lock wl;

    public AbstractCache(Map<K, V> map) {
        this.map = map;
        ReentrantReadWriteLock rrwl = new ReentrantReadWriteLock();
        this.rl = rrwl.readLock();
        this.wl = rrwl.writeLock();
    }

    public AbstractCache() {
        this(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, E param) {
        V value;
        try {
            this.rl.lock();
            value = this.map.get(key);
        }
        finally {
            this.rl.unlock();
        }
        if (value != null) {
            return value;
        }
        try {
            this.wl.lock();
            value = this.map.get(key);
            if (value == null) {
                value = this.evaluate(key, param);
                this.map.put(key, value);
            }
        }
        finally {
            this.wl.unlock();
        }
        return value;
    }

    protected abstract V evaluate(K var1, E var2);
}

