/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sql2o.Sql2oException;
import org.sql2o.reflection.FactoryFacade;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.Setter;
import org.sql2o.tools.AbstractCache;
import org.sql2o.tools.UnderscoreToCamelCase;

public class PojoMetadata {
    private static final Cache caseSensitiveFalse = new Cache();
    private static final Cache caseSensitiveTrue = new Cache();
    private final PropertyAndFieldInfo propertyInfo;
    private final Map<String, String> columnMappings;
    private final FactoryFacade factoryFacade = FactoryFacade.getInstance();
    private boolean caseSensitive;
    private boolean autoDeriveColumnNames;
    public final boolean throwOnMappingFailure;
    private Class clazz;

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isAutoDeriveColumnNames() {
        return this.autoDeriveColumnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoMetadata that = (PojoMetadata)o;
        return this.autoDeriveColumnNames == that.autoDeriveColumnNames && this.caseSensitive == that.caseSensitive && this.clazz.equals(that.clazz) && this.columnMappings.equals(that.columnMappings) && this.propertyInfo.equals(that.propertyInfo);
    }

    public int hashCode() {
        int result = this.caseSensitive ? 1 : 0;
        result = 31 * result + this.clazz.hashCode();
        return result;
    }

    public PojoMetadata(Class clazz, boolean caseSensitive, boolean autoDeriveColumnNames, Map<String, String> columnMappings, boolean throwOnMappingError) {
        this.caseSensitive = caseSensitive;
        this.autoDeriveColumnNames = autoDeriveColumnNames;
        this.clazz = clazz;
        this.columnMappings = columnMappings == null ? Collections.emptyMap() : columnMappings;
        this.propertyInfo = this.getPropertyInfoThroughCache();
        this.throwOnMappingFailure = throwOnMappingError;
    }

    public ObjectConstructor getObjectConstructor() {
        return this.propertyInfo.objectConstructor;
    }

    private PropertyAndFieldInfo getPropertyInfoThroughCache() {
        return (PropertyAndFieldInfo)(this.caseSensitive ? caseSensitiveTrue : caseSensitiveFalse).get(this.clazz, this);
    }

    private PropertyAndFieldInfo initializePropertyInfo() {
        HashMap<String, Setter> propertySetters = new HashMap<String, Setter>();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class theClass = this.clazz;
        ObjectConstructor objectConstructor = this.factoryFacade.newConstructor(theClass);
        do {
            String propertyName;
            for (Field field : theClass.getDeclaredFields()) {
                propertyName = field.getName();
                propertyName = this.caseSensitive ? propertyName : propertyName.toLowerCase();
                propertySetters.put(propertyName, this.factoryFacade.newSetter(field));
                fields.put(propertyName, field);
            }
            for (AccessibleObject accessibleObject : theClass.getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterTypes().length != 1 || !((Method)accessibleObject).getName().startsWith("set")) continue;
                propertyName = ((Method)accessibleObject).getName().substring(3);
                propertyName = this.caseSensitive ? propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1) : propertyName.toLowerCase();
                propertySetters.put(propertyName, this.factoryFacade.newSetter((Method)accessibleObject));
            }
        } while (!(theClass = theClass.getSuperclass()).equals(Object.class));
        return new PropertyAndFieldInfo(propertySetters, fields, objectConstructor);
    }

    public Map<String, String> getColumnMappings() {
        return this.columnMappings;
    }

    public Setter getPropertySetter(String propertyName) {
        Setter setter = this.getPropertySetterIfExists(propertyName);
        if (setter != null) {
            return setter;
        }
        String errorMsg = "Property with name '" + propertyName + "' not found on class " + this.clazz.toString();
        if (this.caseSensitive) {
            errorMsg = errorMsg + " (You have turned on case sensitive property search. Is this intentional?)";
        }
        throw new Sql2oException(errorMsg);
    }

    public Setter getPropertySetterIfExists(String propertyName) {
        String name;
        String string = name = this.caseSensitive ? propertyName : propertyName.toLowerCase();
        if (this.columnMappings.containsKey(name)) {
            name = this.columnMappings.get(name);
        }
        if (this.autoDeriveColumnNames) {
            name = UnderscoreToCamelCase.convert(name);
            if (!this.caseSensitive) {
                name = name.toLowerCase();
            }
        }
        return this.propertyInfo.propertySetters.get(name);
    }

    public Class getType() {
        return this.clazz;
    }

    public Object getValueOfProperty(String propertyName, Object object) {
        String name = this.caseSensitive ? propertyName : propertyName.toLowerCase();
        Field field = this.propertyInfo.fields.get(name);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new Sql2oException("could not read value of field " + field.getName() + " on class " + object.getClass().toString(), e);
        }
    }

    private static class PropertyAndFieldInfo {
        public final Map<String, Setter> propertySetters;
        public final Map<String, Field> fields;
        public final ObjectConstructor objectConstructor;

        private PropertyAndFieldInfo(Map<String, Setter> propertySetters, Map<String, Field> fields, ObjectConstructor objectConstructor) {
            this.propertySetters = propertySetters;
            this.fields = fields;
            this.objectConstructor = objectConstructor;
        }
    }

    private static class Cache
    extends AbstractCache<Class, PropertyAndFieldInfo, PojoMetadata> {
        private Cache() {
        }

        @Override
        protected PropertyAndFieldInfo evaluate(Class key, PojoMetadata param) {
            return param.initializePropertyInfo();
        }
    }
}

