/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sql2o.reflection.FieldSetterFactory;
import org.sql2o.reflection.MethodSetterFactory;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.ObjectConstructorFactory;
import org.sql2o.reflection.ReflectionFieldSetterFactory;
import org.sql2o.reflection.ReflectionMethodSetterFactory;
import org.sql2o.reflection.ReflectionObjectConstructorFactory;
import org.sql2o.reflection.Setter;

public class FactoryFacade {
    private static final FactoryFacade instance;
    private final FieldSetterFactory fieldSetterFactory;
    private final MethodSetterFactory methodSetterFactory;
    private final ObjectConstructorFactory objectConstructorFactory;

    public FactoryFacade(FieldSetterFactory fieldSetterFactory, MethodSetterFactory methodSetterFactory, ObjectConstructorFactory objectConstructorFactory) {
        this.fieldSetterFactory = fieldSetterFactory;
        this.methodSetterFactory = methodSetterFactory;
        this.objectConstructorFactory = objectConstructorFactory;
    }

    public static FactoryFacade getInstance() {
        return instance;
    }

    public Setter newSetter(Field field) {
        return this.fieldSetterFactory.newSetter(field);
    }

    public Setter newSetter(Method method) {
        return this.methodSetterFactory.newSetter(method);
    }

    public ObjectConstructor newConstructor(Class<?> cls) {
        return this.objectConstructorFactory.newConstructor(cls);
    }

    static {
        FieldSetterFactory f;
        ObjectConstructorFactory o;
        MethodSetterFactory m;
        try {
            m = (MethodSetterFactory)Class.forName("org.sql2o.reflection.MethodAccessorsGenerator").newInstance();
            o = (ObjectConstructorFactory)((Object)m);
        }
        catch (Throwable ex) {
            m = new ReflectionMethodSetterFactory();
            o = null;
        }
        try {
            Class<?> cls = Class.forName("org.sql2o.reflection.UnsafeFieldSetterFactory");
            f = (FieldSetterFactory)cls.newInstance();
            if (o == null) {
                o = (ObjectConstructorFactory)((Object)f);
            }
        }
        catch (Throwable ex) {
            f = new ReflectionFieldSetterFactory();
            o = new ReflectionObjectConstructorFactory();
        }
        instance = new FactoryFacade(f, m, o);
    }
}

