/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks.spi;

import org.sql2o.quirks.Db2Quirks;
import org.sql2o.quirks.OracleQuirks;
import org.sql2o.quirks.PostgresQuirks;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksProvider;

public class QuirksProviderImpl
implements QuirksProvider {
    @Override
    public Quirks forURL(String jdbcUrl) {
        if (jdbcUrl.startsWith("jdbc:oracle:")) {
            return oracleQuirks.q;
        }
        if (jdbcUrl.startsWith("jdbc:db2:")) {
            return db2Quirks.q;
        }
        if (jdbcUrl.startsWith("jdbc:db2j:net:")) {
            return db2Quirks.q;
        }
        if (jdbcUrl.startsWith("jdbc:db2os390")) {
            return db2Quirks.q;
        }
        if (jdbcUrl.startsWith("jdbc:postgresql:")) {
            return postgresQuirks.q;
        }
        return null;
    }

    @Override
    public Quirks forObject(Object jdbcObject) {
        String className = jdbcObject.getClass().getCanonicalName();
        if (className.startsWith("oracle.jdbc.")) {
            return oracleQuirks.q;
        }
        if (className.startsWith("oracle.sql.")) {
            return oracleQuirks.q;
        }
        if (className.startsWith("com.ibm.db2.jcc.DB2")) {
            return db2Quirks.q;
        }
        if (className.startsWith("org.postgresql.")) {
            return postgresQuirks.q;
        }
        return null;
    }

    private static class postgresQuirks {
        static final Quirks q = new PostgresQuirks();

        private postgresQuirks() {
        }
    }

    private static class db2Quirks {
        static final Quirks q = new Db2Quirks();

        private db2Quirks() {
        }
    }

    private static class oracleQuirks {
        static final Quirks q = new OracleQuirks();

        private oracleQuirks() {
        }
    }
}

