/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks;

import java.util.ServiceLoader;
import org.sql2o.GenericDatasource;
import org.sql2o.quirks.NoQuirks;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksProvider;

public class QuirksDetector {
    static final ServiceLoader<QuirksProvider> providers = ServiceLoader.load(QuirksProvider.class);

    public static Quirks forURL(String jdbcUrl) {
        for (QuirksProvider provider : providers) {
            Quirks quirks = provider.forURL(jdbcUrl);
            if (quirks == null) continue;
            return quirks;
        }
        return new NoQuirks();
    }

    public static Quirks forObject(Object jdbcObject) {
        if (jdbcObject instanceof GenericDatasource) {
            return QuirksDetector.forURL(((GenericDatasource)jdbcObject).getUrl());
        }
        for (QuirksProvider provider : providers) {
            Quirks quirks = provider.forObject(jdbcObject);
            if (quirks == null) continue;
            return quirks;
        }
        return new NoQuirks();
    }
}

