/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sql2o.Sql2oException;
import org.sql2o.converters.Convert;
import org.sql2o.converters.ConverterException;
import org.sql2o.quirks.Quirks;

public class Row {
    private final Object[] values;
    private final boolean isCaseSensitive;
    private final Quirks quirks;
    private final Map<String, Integer> columnNameToIdxMap;

    public Row(Map<String, Integer> columnNameToIdxMap, int columnCnt, boolean isCaseSensitive, Quirks quirks) {
        this.columnNameToIdxMap = columnNameToIdxMap;
        this.isCaseSensitive = isCaseSensitive;
        this.quirks = quirks;
        this.values = new Object[columnCnt];
    }

    void addValue(int columnIndex, Object value) {
        this.values[columnIndex] = value;
    }

    public Object getObject(int columnIndex) {
        return this.values[columnIndex];
    }

    public Object getObject(String columnName) {
        Integer index = this.columnNameToIdxMap.get(this.isCaseSensitive ? columnName : columnName.toLowerCase());
        if (index != null) {
            return this.getObject(index);
        }
        throw new Sql2oException(String.format("Column with name '%s' does not exist", columnName));
    }

    public <V> V getObject(int columnIndex, Class clazz) {
        try {
            return (V)Convert.throwIfNull(clazz, this.quirks.converterOf(clazz)).convert(this.getObject(columnIndex));
        }
        catch (ConverterException ex) {
            throw new Sql2oException("Error converting value", ex);
        }
    }

    public <V> V getObject(String columnName, Class clazz) {
        try {
            return (V)Convert.throwIfNull(clazz, this.quirks.converterOf(clazz)).convert(this.getObject(columnName));
        }
        catch (ConverterException ex) {
            throw new Sql2oException("Error converting value", ex);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        return (BigDecimal)this.getObject(columnIndex, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(String columnName) {
        return (BigDecimal)this.getObject(columnName, BigDecimal.class);
    }

    public Double getDouble(int columnIndex) {
        return (Double)this.getObject(columnIndex, Double.class);
    }

    public Double getDouble(String columnName) {
        return (Double)this.getObject(columnName, Double.class);
    }

    public Float getFloat(int columnIndex) {
        return (Float)this.getObject(columnIndex, Float.class);
    }

    public Float getFloat(String columnName) {
        return (Float)this.getObject(columnName, Float.class);
    }

    public Long getLong(int columnIndex) {
        return (Long)this.getObject(columnIndex, Long.class);
    }

    public Long getLong(String columnName) {
        return (Long)this.getObject(columnName, Long.class);
    }

    public Integer getInteger(int columnIndex) {
        return (Integer)this.getObject(columnIndex, Integer.class);
    }

    public Integer getInteger(String columnName) {
        return (Integer)this.getObject(columnName, Integer.class);
    }

    public Short getShort(int columnIndex) {
        return (Short)this.getObject(columnIndex, Short.class);
    }

    public Short getShort(String columnName) {
        return (Short)this.getObject(columnName, Short.class);
    }

    public Byte getByte(int columnIndex) {
        return (Byte)this.getObject(columnIndex, Byte.class);
    }

    public Byte getByte(String columnName) {
        return (Byte)this.getObject(columnName, Byte.class);
    }

    public Date getDate(int columnIndex) {
        return (Date)this.getObject(columnIndex, Date.class);
    }

    public Date getDate(String columnName) {
        return (Date)this.getObject(columnName, Date.class);
    }

    public String getString(int columnIndex) {
        return (String)this.getObject(columnIndex, String.class);
    }

    public String getString(String columnName) {
        return (String)this.getObject(columnName, String.class);
    }

    public Map<String, Object> asMap() {
        final List<Object> listOfValues = Arrays.asList(this.values);
        return new Map<String, Object>(){

            @Override
            public int size() {
                return Row.this.values.length;
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public boolean containsKey(Object key) {
                return Row.this.columnNameToIdxMap.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return listOfValues.contains(value);
            }

            @Override
            public Object get(Object key) {
                return Row.this.values[(Integer)Row.this.columnNameToIdxMap.get(key)];
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException("Row map is immutable.");
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException("Row map is immutable.");
            }

            @Override
            public void putAll(Map<? extends String, ?> m) {
                throw new UnsupportedOperationException("Row map is immutable.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Row map is immutable.");
            }

            @Override
            public Set<String> keySet() {
                return Row.this.columnNameToIdxMap.keySet();
            }

            @Override
            public Collection<Object> values() {
                return listOfValues;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException("Row map does not support entrySet.");
            }
        };
    }
}

