/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.sql2o.converters.AbstractDateConverter;
import org.sql2o.converters.BigDecimalConverter;
import org.sql2o.converters.BooleanConverter;
import org.sql2o.converters.ByteArrayConverter;
import org.sql2o.converters.ByteConverter;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.ConvertersProvider;
import org.sql2o.converters.DateConverter;
import org.sql2o.converters.DefaultEnumConverterFactory;
import org.sql2o.converters.DoubleConverter;
import org.sql2o.converters.EnumConverterFactory;
import org.sql2o.converters.FloatConverter;
import org.sql2o.converters.InputStreamConverter;
import org.sql2o.converters.IntegerConverter;
import org.sql2o.converters.LongConverter;
import org.sql2o.converters.ShortConverter;
import org.sql2o.converters.StringConverter;
import org.sql2o.converters.UUIDConverter;
import org.sql2o.converters.joda.DateTimeConverter;
import org.sql2o.converters.joda.LocalTimeConverter;
import org.sql2o.tools.FeatureDetector;

public class Convert {
    private static final ReentrantReadWriteLock rrwl = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock rl = rrwl.readLock();
    private static final ReentrantReadWriteLock.WriteLock wl = rrwl.writeLock();
    private static volatile EnumConverterFactory registeredEnumConverterFactory = new DefaultEnumConverterFactory();
    private static Map<Class<?>, Converter<?>> registeredConverters = new HashMap();

    private static void processProvider(ConvertersProvider convertersProvider) {
        convertersProvider.fill(registeredConverters);
    }

    private static void fillDefaults(Map<Class<?>, Converter<?>> mapToFill) {
        mapToFill.put(Integer.class, new IntegerConverter(false));
        mapToFill.put(Integer.TYPE, new IntegerConverter(true));
        mapToFill.put(Double.class, new DoubleConverter(false));
        mapToFill.put(Double.TYPE, new DoubleConverter(true));
        mapToFill.put(Float.class, new FloatConverter(false));
        mapToFill.put(Float.TYPE, new FloatConverter(true));
        mapToFill.put(Long.class, new LongConverter(false));
        mapToFill.put(Long.TYPE, new LongConverter(true));
        mapToFill.put(Short.class, new ShortConverter(false));
        mapToFill.put(Short.TYPE, new ShortConverter(true));
        mapToFill.put(Byte.class, new ByteConverter(false));
        mapToFill.put(Byte.TYPE, new ByteConverter(true));
        mapToFill.put(BigDecimal.class, new BigDecimalConverter());
        mapToFill.put(String.class, new StringConverter());
        mapToFill.put(java.util.Date.class, DateConverter.instance);
        mapToFill.put(Date.class, new AbstractDateConverter<Date>(Date.class){

            @Override
            protected Date fromMilliseconds(long millisecond) {
                return new Date(millisecond);
            }
        });
        mapToFill.put(Time.class, new AbstractDateConverter<Time>(Time.class){

            @Override
            protected Time fromMilliseconds(long millisecond) {
                return new Time(millisecond);
            }
        });
        mapToFill.put(Timestamp.class, new AbstractDateConverter<Timestamp>(Timestamp.class){

            @Override
            protected Timestamp fromMilliseconds(long millisecond) {
                return new Timestamp(millisecond);
            }
        });
        BooleanConverter booleanConverter = new BooleanConverter();
        mapToFill.put(Boolean.class, booleanConverter);
        mapToFill.put(Boolean.TYPE, booleanConverter);
        ByteArrayConverter byteArrayConverter = new ByteArrayConverter();
        mapToFill.put(byte[].class, byteArrayConverter);
        InputStreamConverter inputStreamConverter = new InputStreamConverter();
        mapToFill.put(InputStream.class, inputStreamConverter);
        mapToFill.put(ByteArrayInputStream.class, inputStreamConverter);
        mapToFill.put(UUID.class, new UUIDConverter());
        if (FeatureDetector.isJodaTimeAvailable()) {
            mapToFill.put(DateTime.class, new DateTimeConverter());
            mapToFill.put(LocalTime.class, new LocalTimeConverter());
        }
    }

    @Deprecated
    public static Converter getConverter(Class clazz) throws ConverterException {
        return Convert.throwIfNull(clazz, Convert.getConverterIfExists(clazz));
    }

    public static <E> Converter<E> throwIfNull(Class<E> clazz, Converter<E> converter) throws ConverterException {
        if (converter == null) {
            throw new ConverterException("No converter registered for class: " + clazz.getName());
        }
        return converter;
    }

    public static <E> Converter<E> getConverterIfExists(Class<E> clazz) {
        Converter<?> c;
        rl.lock();
        try {
            c = registeredConverters.get(clazz);
        }
        finally {
            rl.unlock();
        }
        if (c != null) {
            return c;
        }
        if (clazz.isEnum()) {
            return registeredEnumConverterFactory.newConverter(clazz);
        }
        return null;
    }

    @Deprecated
    public static void registerConverter(Class clazz, Converter converter) {
        wl.lock();
        try {
            Convert.registerConverter0(clazz, converter);
        }
        finally {
            wl.unlock();
        }
    }

    private static void registerConverter0(Class clazz, Converter converter) {
        registeredConverters.put(clazz, converter);
    }

    public static void registerEnumConverter(EnumConverterFactory enumConverterFactory) {
        if (enumConverterFactory == null) {
            throw new IllegalArgumentException();
        }
        registeredEnumConverterFactory = enumConverterFactory;
    }

    static {
        Convert.fillDefaults(registeredConverters);
        ServiceLoader<ConvertersProvider> loader = ServiceLoader.load(ConvertersProvider.class);
        for (ConvertersProvider provider : loader) {
            Convert.processProvider(provider);
        }
    }
}

