/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class BooleanConverter
extends ConverterBase<Boolean> {
    @Override
    public Boolean convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() != 0;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue() == 'Y' || ((Character)val).charValue() == 'T' || ((Character)val).charValue() == 'J';
        }
        if (val instanceof String) {
            String strVal = ((String)val).trim();
            return "Y".equalsIgnoreCase(strVal) || "YES".equalsIgnoreCase(strVal) || "TRUE".equalsIgnoreCase(strVal) || "T".equalsIgnoreCase(strVal) || "J".equalsIgnoreCase(strVal);
        }
        throw new ConverterException("Don't know how to convert type " + val.getClass().getName() + " to " + Boolean.class.getName());
    }
}

