/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Timestamp;
import java.util.Date;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;

public abstract class AbstractDateConverter<E extends Date>
implements Converter<E> {
    private final Class<E> classOfDate;

    protected AbstractDateConverter(Class<E> classOfDate) {
        this.classOfDate = classOfDate;
    }

    protected abstract E fromMilliseconds(long var1);

    @Override
    public E convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (this.classOfDate.isInstance(val)) {
            return (E)((Date)val);
        }
        if (val instanceof Date) {
            return this.fromMilliseconds(((Date)val).getTime());
        }
        if (val instanceof Number) {
            return this.fromMilliseconds(((Number)val).longValue());
        }
        throw new ConverterException("Cannot convert type " + val.getClass().toString() + " to java.util.Date");
    }

    public Timestamp toDatabaseParam(Date val) {
        if (val == null) {
            return null;
        }
        return val instanceof Timestamp ? (Timestamp)val : new Timestamp(val.getTime());
    }
}

