/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.sql2o.Connection;
import org.sql2o.GenericDatasource;
import org.sql2o.JndiDataSource;
import org.sql2o.Query;
import org.sql2o.QuirksMode;
import org.sql2o.Sql2oException;
import org.sql2o.StatementRunnable;
import org.sql2o.StatementRunnableWithResult;
import org.sql2o.logging.LocalLoggerFactory;
import org.sql2o.logging.Logger;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksDetector;

public class Sql2o {
    final Quirks quirks;
    private final DataSource dataSource;
    private Map<String, String> defaultColumnMappings;
    private boolean defaultCaseSensitive;
    private static final Logger logger = LocalLoggerFactory.getLogger(Sql2o.class);

    public Sql2o(String jndiLookup) {
        this(JndiDataSource.getJndiDatasource(jndiLookup));
    }

    public Sql2o(String url, String user, String pass) {
        this(url, user, pass, QuirksDetector.forURL(url));
    }

    @Deprecated
    public Sql2o(String url, String user, String pass, QuirksMode quirksMode) {
        this((DataSource)new GenericDatasource(url, user, pass), quirksMode);
    }

    public Sql2o(String url, String user, String pass, Quirks quirks) {
        this((DataSource)new GenericDatasource(url, user, pass), quirks);
    }

    public Sql2o(DataSource dataSource) {
        this(dataSource, QuirksDetector.forObject(dataSource));
    }

    @Deprecated
    public Sql2o(DataSource dataSource, QuirksMode quirksMode) {
        this(dataSource, quirksMode.quirks);
    }

    public Sql2o(DataSource dataSource, Quirks quirks) {
        this.dataSource = dataSource;
        this.quirks = quirks;
        this.defaultColumnMappings = new HashMap<String, String>();
    }

    public Quirks getQuirks() {
        return this.quirks;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Map<String, String> getDefaultColumnMappings() {
        return this.defaultColumnMappings;
    }

    public void setDefaultColumnMappings(Map<String, String> defaultColumnMappings) {
        this.defaultColumnMappings = defaultColumnMappings;
    }

    public boolean isDefaultCaseSensitive() {
        return this.defaultCaseSensitive;
    }

    public void setDefaultCaseSensitive(boolean defaultCaseSensitive) {
        this.defaultCaseSensitive = defaultCaseSensitive;
    }

    @Deprecated
    public Query createQuery(String query, String name, boolean returnGeneratedKeys) {
        return new Connection(this, true).createQuery(query, name, returnGeneratedKeys);
    }

    @Deprecated
    public Query createQuery(String query, boolean returnGeneratedKeys) {
        return this.createQuery(query, null, returnGeneratedKeys);
    }

    @Deprecated
    public Query createQuery(String query, String name) {
        Connection connection = new Connection(this, true);
        return connection.createQuery(query, name);
    }

    @Deprecated
    public Query createQuery(String query) {
        return this.createQuery(query, null);
    }

    public Connection open() {
        return new Connection(this, false);
    }

    public <V> V withConnection(StatementRunnableWithResult runnable, Object argument) {
        try (Connection connection = null;){
            connection = this.open();
            Object object = runnable.run(connection, argument);
            return (V)object;
        }
    }

    public <V> V withConnection(StatementRunnableWithResult runnable) {
        return this.withConnection(runnable, null);
    }

    public void withConnection(StatementRunnable runnable) {
        this.withConnection(runnable, null);
    }

    public void withConnection(StatementRunnable runnable, Object argument) {
        try (Connection connection = null;){
            connection = this.open();
            runnable.run(connection, argument);
        }
    }

    public Connection beginTransaction(int isolationLevel) {
        Connection connection = new Connection(this, false);
        try {
            connection.getJdbcConnection().setAutoCommit(false);
            connection.getJdbcConnection().setTransactionIsolation(isolationLevel);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return connection;
    }

    public Connection beginTransaction() {
        return this.beginTransaction(2);
    }

    public void runInTransaction(StatementRunnable runnable) {
        this.runInTransaction(runnable, null);
    }

    public void runInTransaction(StatementRunnable runnable, Object argument) {
        this.runInTransaction(runnable, argument, 2);
    }

    public void runInTransaction(StatementRunnable runnable, Object argument, int isolationLevel) {
        Connection connection = this.beginTransaction(isolationLevel);
        connection.setRollbackOnException(false);
        try {
            runnable.run(connection, argument);
        }
        catch (Throwable throwable) {
            connection.rollback();
            throw new Sql2oException("An error occurred while executing StatementRunnable. Transaction is rolled back.", throwable);
        }
        connection.commit();
    }

    public <V> V runInTransaction(StatementRunnableWithResult runnableWithResult) {
        return this.runInTransaction(runnableWithResult, null);
    }

    public <V> V runInTransaction(StatementRunnableWithResult runnableWithResult, Object argument) {
        return this.runInTransaction(runnableWithResult, argument, 2);
    }

    public <V> V runInTransaction(StatementRunnableWithResult runnableWithResult, Object argument, int isolationLevel) {
        Object result;
        Connection connection = this.beginTransaction(isolationLevel);
        try {
            result = runnableWithResult.run(connection, argument);
        }
        catch (Throwable throwable) {
            connection.rollback();
            throw new Sql2oException("An error occurred while executing StatementRunnableWithResult. Transaction rolled back.", throwable);
        }
        connection.commit();
        return (V)result;
    }
}

