/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sql2o.Sql2oException;
import org.sql2o.quirks.Quirks;

public abstract class ResultSetIteratorBase<T>
implements Iterator<T> {
    protected ResultSet rs;
    protected boolean isCaseSensitive;
    protected Quirks quirks;
    protected ResultSetMetaData meta;
    private ResultSetValue<T> next;
    private boolean resultSetFinished;

    public ResultSetIteratorBase(ResultSet rs, boolean isCaseSensitive, Quirks quirks) {
        this.rs = rs;
        this.isCaseSensitive = isCaseSensitive;
        this.quirks = quirks;
        try {
            this.meta = rs.getMetaData();
        }
        catch (SQLException ex) {
            throw new Sql2oException("Database error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.resultSetFinished) {
            return false;
        }
        this.next = this.safeReadNext();
        if (this.next != null) {
            return true;
        }
        this.resultSetFinished = true;
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.next.value;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ResultSetValue<T> safeReadNext() {
        try {
            if (!this.rs.next()) {
                return null;
            }
            return new ResultSetValue<T>(this.readNext());
        }
        catch (SQLException ex) {
            throw new Sql2oException("Database error: " + ex.getMessage(), ex);
        }
    }

    protected abstract T readNext() throws SQLException;

    protected String getColumnName(int colIdx) throws SQLException {
        return this.quirks.getColumnName(this.meta, colIdx);
    }

    private final class ResultSetValue<T> {
        public final T value;

        public ResultSetValue(T value) {
            this.value = value;
        }
    }
}

