/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sql2o.Query;
import org.sql2o.Sql2o;
import org.sql2o.Sql2oException;
import org.sql2o.converters.Convert;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.logging.LocalLoggerFactory;
import org.sql2o.logging.Logger;
import org.sql2o.quirks.Quirks;

public class Connection
implements AutoCloseable {
    private static final Logger logger = LocalLoggerFactory.getLogger(Connection.class);
    private java.sql.Connection jdbcConnection;
    private Sql2o sql2o;
    private Integer result = null;
    private int[] batchResult = null;
    private List<Object> keys;
    private boolean canGetKeys;
    private boolean rollbackOnException = true;
    final boolean autoClose;
    private final Set<Statement> statements = new HashSet<Statement>();

    public boolean isRollbackOnException() {
        return this.rollbackOnException;
    }

    public Connection setRollbackOnException(boolean rollbackOnException) {
        this.rollbackOnException = rollbackOnException;
        return this;
    }

    Connection(Sql2o sql2o, boolean autoClose) {
        this.autoClose = autoClose;
        this.sql2o = sql2o;
        this.createConnection();
    }

    void onException() {
        if (this.isRollbackOnException()) {
            this.rollback(this.autoClose);
        }
    }

    public java.sql.Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public Sql2o getSql2o() {
        return this.sql2o;
    }

    public Query createQuery(String queryText, String name) {
        boolean returnGeneratedKeys = this.sql2o.getQuirks().returnGeneratedKeysByDefault();
        return this.createQuery(queryText, name, returnGeneratedKeys);
    }

    public Query createQuery(String queryText, String name, boolean returnGeneratedKeys) {
        try {
            if (this.jdbcConnection.isClosed()) {
                this.createConnection();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new Query(this, queryText, name, returnGeneratedKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQueryWithParams(String queryText, Object ... paramValues) {
        Query query = this.createQuery(queryText, null);
        boolean destroy = true;
        try {
            query.withParams(paramValues);
            destroy = false;
            Query query2 = query;
            return query2;
        }
        finally {
            if (destroy) {
                query.close();
            }
        }
    }

    public Query createQuery(String queryText) {
        return this.createQuery(queryText, null);
    }

    public Query createQuery(String queryText, boolean returnGeneratedKeys) {
        return this.createQuery(queryText, null, returnGeneratedKeys);
    }

    public Sql2o rollback() {
        return this.rollback((boolean)true).sql2o;
    }

    public Connection rollback(boolean closeConnection) {
        try {
            this.jdbcConnection.rollback();
        }
        catch (SQLException e) {
            logger.warn("Could not roll back transaction. message: {}", e);
        }
        finally {
            if (closeConnection) {
                this.closeJdbcConnection();
            }
        }
        return this;
    }

    public Sql2o commit() {
        return this.commit((boolean)true).sql2o;
    }

    public Connection commit(boolean closeConnection) {
        try {
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new Sql2oException(e);
        }
        finally {
            if (closeConnection) {
                this.closeJdbcConnection();
            }
        }
        return this;
    }

    public int getResult() {
        if (this.result == null) {
            throw new Sql2oException("It is required to call executeUpdate() method before calling getResult().");
        }
        return this.result;
    }

    void setResult(int result) {
        this.result = result;
    }

    public int[] getBatchResult() {
        if (this.batchResult == null) {
            throw new Sql2oException("It is required to call executeBatch() method before calling getBatchResult().");
        }
        return this.batchResult;
    }

    void setBatchResult(int[] value) {
        this.batchResult = value;
    }

    void setKeys(ResultSet rs) throws SQLException {
        if (rs == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<Object>();
        while (rs.next()) {
            this.keys.add(rs.getObject(1));
        }
    }

    public Object getKey() {
        if (!this.canGetKeys) {
            throw new Sql2oException("Keys where not fetched from database. Please call executeUpdate(true) to fetch keys");
        }
        if (this.keys != null && this.keys.size() > 0) {
            return this.keys.get(0);
        }
        return null;
    }

    public <V> V getKey(Class returnType) {
        Quirks quirks = this.sql2o.getQuirks();
        Object key = this.getKey();
        try {
            Converter converter = Convert.throwIfNull(returnType, quirks.converterOf(returnType));
            return (V)converter.convert(key);
        }
        catch (ConverterException e) {
            throw new Sql2oException("Exception occurred while converting value from database to type " + returnType.toString(), e);
        }
    }

    public Object[] getKeys() {
        if (!this.canGetKeys) {
            throw new Sql2oException("Keys where not fetched from database. Please set the returnGeneratedKeys parameter in the createQuery() method to enable fetching of generated keys.");
        }
        if (this.keys != null) {
            return this.keys.toArray();
        }
        return null;
    }

    public <V> List<V> getKeys(Class<V> returnType) {
        Quirks quirks = this.sql2o.getQuirks();
        if (!this.canGetKeys) {
            throw new Sql2oException("Keys where not fetched from database. Please set the returnGeneratedKeys parameter in the createQuery() method to enable fetching of generated keys.");
        }
        if (this.keys != null) {
            try {
                Converter<V> converter = Convert.throwIfNull(returnType, quirks.converterOf(returnType));
                ArrayList<V> convertedKeys = new ArrayList<V>(this.keys.size());
                for (Object key : this.keys) {
                    convertedKeys.add(converter.convert(key));
                }
                return convertedKeys;
            }
            catch (ConverterException e) {
                throw new Sql2oException("Exception occurred while converting value from database to type " + returnType.toString(), e);
            }
        }
        return null;
    }

    void setCanGetKeys(boolean canGetKeys) {
        this.canGetKeys = canGetKeys;
    }

    void registerStatement(Statement statement) {
        this.statements.add(statement);
    }

    void removeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    @Override
    public void close() {
        boolean connectionIsClosed;
        try {
            connectionIsClosed = this.jdbcConnection.isClosed();
        }
        catch (SQLException e) {
            throw new Sql2oException("Sql2o encountered a problem while trying to determine whether the connection is closed.", e);
        }
        if (!connectionIsClosed) {
            for (Statement statement : this.statements) {
                try {
                    this.getSql2o().getQuirks().closeStatement(statement);
                }
                catch (Throwable e) {
                    logger.warn("Could not close statement.", e);
                }
            }
            this.statements.clear();
            boolean autoCommit = false;
            try {
                autoCommit = this.jdbcConnection.getAutoCommit();
            }
            catch (SQLException e) {
                logger.warn("Could not determine connection auto commit mode.", e);
            }
            if (autoCommit) {
                this.closeJdbcConnection();
            } else {
                this.rollback(true);
            }
        }
    }

    private void createConnection() {
        try {
            this.jdbcConnection = this.sql2o.getDataSource().getConnection();
        }
        catch (Exception ex) {
            throw new Sql2oException("Could not acquire a connection from DataSource - " + ex.getMessage(), ex);
        }
    }

    private void closeJdbcConnection() {
        try {
            this.jdbcConnection.close();
        }
        catch (SQLException e) {
            logger.warn("Could not close connection. message: {}", e);
        }
    }
}

