/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.config.AnnotationDrivenBeanDefinitionParser;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.util.UrlPathHelper;

abstract class MvcNamespaceUtils {
    private static final String BEAN_NAME_URL_HANDLER_MAPPING_BEAN_NAME = BeanNameUrlHandlerMapping.class.getName();
    private static final String SIMPLE_CONTROLLER_HANDLER_ADAPTER_BEAN_NAME = SimpleControllerHandlerAdapter.class.getName();
    private static final String HTTP_REQUEST_HANDLER_ADAPTER_BEAN_NAME = HttpRequestHandlerAdapter.class.getName();
    private static final String URL_PATH_HELPER_BEAN_NAME = "mvcUrlPathHelper";
    private static final String PATH_MATCHER_BEAN_NAME = "mvcPathMatcher";
    private static final String CORS_CONFIGURATION_BEAN_NAME = "mvcCorsConfigurations";
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";

    MvcNamespaceUtils() {
    }

    public static void registerDefaultComponents(ParserContext parserContext, Object source) {
        MvcNamespaceUtils.registerBeanNameUrlHandlerMapping(parserContext, source);
        MvcNamespaceUtils.registerHttpRequestHandlerAdapter(parserContext, source);
        MvcNamespaceUtils.registerSimpleControllerHandlerAdapter(parserContext, source);
        MvcNamespaceUtils.registerHandlerMappingIntrospector(parserContext, source);
    }

    public static RuntimeBeanReference registerUrlPathHelper(RuntimeBeanReference urlPathHelperRef, ParserContext parserContext, Object source) {
        if (urlPathHelperRef != null) {
            if (parserContext.getRegistry().isAlias(URL_PATH_HELPER_BEAN_NAME)) {
                parserContext.getRegistry().removeAlias(URL_PATH_HELPER_BEAN_NAME);
            }
            parserContext.getRegistry().registerAlias(urlPathHelperRef.getBeanName(), URL_PATH_HELPER_BEAN_NAME);
        } else if (!parserContext.getRegistry().isAlias(URL_PATH_HELPER_BEAN_NAME) && !parserContext.getRegistry().containsBeanDefinition(URL_PATH_HELPER_BEAN_NAME)) {
            RootBeanDefinition urlPathHelperDef = new RootBeanDefinition(UrlPathHelper.class);
            urlPathHelperDef.setSource(source);
            urlPathHelperDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(URL_PATH_HELPER_BEAN_NAME, (BeanDefinition)urlPathHelperDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)urlPathHelperDef, URL_PATH_HELPER_BEAN_NAME));
        }
        return new RuntimeBeanReference(URL_PATH_HELPER_BEAN_NAME);
    }

    public static RuntimeBeanReference registerPathMatcher(RuntimeBeanReference pathMatcherRef, ParserContext parserContext, Object source) {
        if (pathMatcherRef != null) {
            if (parserContext.getRegistry().isAlias(PATH_MATCHER_BEAN_NAME)) {
                parserContext.getRegistry().removeAlias(PATH_MATCHER_BEAN_NAME);
            }
            parserContext.getRegistry().registerAlias(pathMatcherRef.getBeanName(), PATH_MATCHER_BEAN_NAME);
        } else if (!parserContext.getRegistry().isAlias(PATH_MATCHER_BEAN_NAME) && !parserContext.getRegistry().containsBeanDefinition(PATH_MATCHER_BEAN_NAME)) {
            RootBeanDefinition pathMatcherDef = new RootBeanDefinition(AntPathMatcher.class);
            pathMatcherDef.setSource(source);
            pathMatcherDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(PATH_MATCHER_BEAN_NAME, (BeanDefinition)pathMatcherDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)pathMatcherDef, PATH_MATCHER_BEAN_NAME));
        }
        return new RuntimeBeanReference(PATH_MATCHER_BEAN_NAME);
    }

    private static void registerBeanNameUrlHandlerMapping(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(BEAN_NAME_URL_HANDLER_MAPPING_BEAN_NAME)) {
            RootBeanDefinition beanNameMappingDef = new RootBeanDefinition(BeanNameUrlHandlerMapping.class);
            beanNameMappingDef.setSource(source);
            beanNameMappingDef.setRole(2);
            beanNameMappingDef.getPropertyValues().add("order", (Object)2);
            RuntimeBeanReference corsConfigurationsRef = MvcNamespaceUtils.registerCorsConfigurations(null, parserContext, source);
            beanNameMappingDef.getPropertyValues().add("corsConfigurations", (Object)corsConfigurationsRef);
            parserContext.getRegistry().registerBeanDefinition(BEAN_NAME_URL_HANDLER_MAPPING_BEAN_NAME, (BeanDefinition)beanNameMappingDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanNameMappingDef, BEAN_NAME_URL_HANDLER_MAPPING_BEAN_NAME));
        }
    }

    private static void registerHttpRequestHandlerAdapter(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(HTTP_REQUEST_HANDLER_ADAPTER_BEAN_NAME)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(HTTP_REQUEST_HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HTTP_REQUEST_HANDLER_ADAPTER_BEAN_NAME));
        }
    }

    private static void registerSimpleControllerHandlerAdapter(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(SIMPLE_CONTROLLER_HANDLER_ADAPTER_BEAN_NAME)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(SimpleControllerHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(SIMPLE_CONTROLLER_HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, SIMPLE_CONTROLLER_HANDLER_ADAPTER_BEAN_NAME));
        }
    }

    public static RuntimeBeanReference registerCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations, ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(CORS_CONFIGURATION_BEAN_NAME)) {
            RootBeanDefinition corsConfigurationsDef = new RootBeanDefinition(LinkedHashMap.class);
            corsConfigurationsDef.setSource(source);
            corsConfigurationsDef.setRole(2);
            if (corsConfigurations != null) {
                corsConfigurationsDef.getConstructorArgumentValues().addIndexedArgumentValue(0, corsConfigurations);
            }
            parserContext.getReaderContext().getRegistry().registerBeanDefinition(CORS_CONFIGURATION_BEAN_NAME, (BeanDefinition)corsConfigurationsDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)corsConfigurationsDef, CORS_CONFIGURATION_BEAN_NAME));
        } else if (corsConfigurations != null) {
            BeanDefinition corsConfigurationsDef = parserContext.getRegistry().getBeanDefinition(CORS_CONFIGURATION_BEAN_NAME);
            corsConfigurationsDef.getConstructorArgumentValues().addIndexedArgumentValue(0, corsConfigurations);
        }
        return new RuntimeBeanReference(CORS_CONFIGURATION_BEAN_NAME);
    }

    private static void registerHandlerMappingIntrospector(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            RootBeanDefinition beanDef = new RootBeanDefinition(HandlerMappingIntrospector.class);
            beanDef.setSource(source);
            beanDef.setRole(2);
            beanDef.setLazyInit(true);
            parserContext.getRegistry().registerBeanDefinition(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, (BeanDefinition)beanDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME));
        }
    }

    public static Object getContentNegotiationManager(ParserContext context) {
        String name = AnnotationDrivenBeanDefinitionParser.HANDLER_MAPPING_BEAN_NAME;
        if (context.getRegistry().containsBeanDefinition(name)) {
            BeanDefinition handlerMappingBeanDef = context.getRegistry().getBeanDefinition(name);
            return handlerMappingBeanDef.getPropertyValues().get("contentNegotiationManager");
        }
        name = "mvcContentNegotiationManager";
        if (context.getRegistry().containsBeanDefinition(name)) {
            return new RuntimeBeanReference(name);
        }
        return null;
    }
}

