/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.ws.mime.AbstractMimeMessage;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;

public abstract class AbstractSoapMessage
extends AbstractMimeMessage
implements SoapMessage {
    private SoapVersion version;

    @Override
    public final SoapBody getSoapBody() {
        return this.getEnvelope().getBody();
    }

    @Override
    public final SoapHeader getSoapHeader() {
        return this.getEnvelope().getHeader();
    }

    @Override
    public final Source getPayloadSource() {
        return this.getSoapBody().getPayloadSource();
    }

    @Override
    public final Result getPayloadResult() {
        return this.getSoapBody().getPayloadResult();
    }

    @Override
    public final boolean hasFault() {
        return this.getSoapBody().hasFault();
    }

    @Override
    public final QName getFaultCode() {
        if (this.hasFault()) {
            return this.getSoapBody().getFault().getFaultCode();
        }
        return null;
    }

    @Override
    public final String getFaultReason() {
        if (this.hasFault()) {
            return this.getSoapBody().getFault().getFaultStringOrReason();
        }
        return null;
    }

    @Override
    public SoapVersion getVersion() {
        if (this.version == null) {
            String envelopeNamespace = this.getEnvelope().getName().getNamespaceURI();
            if (SoapVersion.SOAP_11.getEnvelopeNamespaceUri().equals(envelopeNamespace)) {
                this.version = SoapVersion.SOAP_11;
            } else if (SoapVersion.SOAP_12.getEnvelopeNamespaceUri().equals(envelopeNamespace)) {
                this.version = SoapVersion.SOAP_12;
            } else {
                throw new IllegalStateException("Unknown Envelope namespace uri '" + envelopeNamespace + "'. " + "Cannot deduce SoapVersion.");
            }
        }
        return this.version;
    }
}

