/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class HttpUrlConnection
extends AbstractHttpSenderConnection {
    private final HttpURLConnection connection;

    protected HttpUrlConnection(HttpURLConnection connection) {
        Assert.notNull((Object)connection, (String)"connection must not be null");
        this.connection = connection;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Override
    public void onClose() {
        this.connection.disconnect();
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return new URI(StringUtils.replace((String)this.connection.getURL().toString(), (String)" ", (String)"%20"));
    }

    @Override
    protected void addRequestHeader(String name, String value) throws IOException {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.connection.connect();
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        return this.connection.getContentLength();
    }

    @Override
    protected Iterator<String> getResponseHeaderNames() throws IOException {
        String headerName;
        ArrayList<String> headerNames = new ArrayList<String>();
        int i = 1;
        while (StringUtils.hasLength((String)(headerName = this.connection.getHeaderFieldKey(i)))) {
            headerNames.add(headerName);
            ++i;
        }
        return headerNames.iterator();
    }

    @Override
    protected Iterator<String> getResponseHeaders(String name) throws IOException {
        String headerField = this.connection.getHeaderField(name);
        if (headerField == null) {
            return Collections.emptyList().iterator();
        }
        Set tokens = StringUtils.commaDelimitedListToSet((String)headerField);
        return tokens.iterator();
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    protected String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        if (this.connection.getResponseCode() / 100 != 2) {
            return this.connection.getErrorStream();
        }
        return this.connection.getInputStream();
    }
}

