/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.EndpointAwareWebServiceConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;
import org.springframework.ws.transport.support.EnumerationIterator;

public class HttpServletConnection
extends AbstractReceiverConnection
implements EndpointAwareWebServiceConnection,
FaultAwareWebServiceConnection {
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private boolean statusCodeSet = false;

    protected HttpServletConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    @Override
    public void endpointNotFound() {
        this.getHttpServletResponse().setStatus(404);
        this.statusCodeSet = true;
    }

    @Override
    public boolean hasError() throws IOException {
        return false;
    }

    @Override
    public String getErrorMessage() throws IOException {
        return null;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return new URI(this.httpServletRequest.getScheme(), null, this.httpServletRequest.getServerName(), this.httpServletRequest.getServerPort(), this.httpServletRequest.getRequestURI(), this.httpServletRequest.getQueryString(), null);
    }

    @Override
    protected Iterator<String> getRequestHeaderNames() throws IOException {
        return new EnumerationIterator<String>(this.getHttpServletRequest().getHeaderNames());
    }

    @Override
    protected Iterator<String> getRequestHeaders(String name) throws IOException {
        return new EnumerationIterator<String>(this.getHttpServletRequest().getHeaders(name));
    }

    @Override
    protected InputStream getRequestInputStream() throws IOException {
        return this.getHttpServletRequest().getInputStream();
    }

    @Override
    protected void addResponseHeader(String name, String value) throws IOException {
        this.getHttpServletResponse().addHeader(name, value);
    }

    @Override
    protected OutputStream getResponseOutputStream() throws IOException {
        return this.getHttpServletResponse().getOutputStream();
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.statusCodeSet = true;
    }

    @Override
    public void onClose() throws IOException {
        if (!this.statusCodeSet) {
            this.getHttpServletResponse().setStatus(202);
        }
    }

    @Override
    public boolean hasFault() throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public void setFault(boolean fault) throws IOException {
        if (fault) {
            this.getHttpServletResponse().setStatus(500);
        } else {
            this.getHttpServletResponse().setStatus(200);
        }
        this.statusCodeSet = true;
    }

    @Override
    public void setFaultCode(QName faultCode) throws IOException {
        if (faultCode != null) {
            if (SOAPConstants.SOAP_SENDER_FAULT.equals(faultCode)) {
                this.getHttpServletResponse().setStatus(400);
            } else {
                this.getHttpServletResponse().setStatus(500);
            }
        } else {
            this.getHttpServletResponse().setStatus(200);
        }
        this.statusCodeSet = true;
    }
}

