/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.springframework.util.Assert;
import org.springframework.xml.namespace.QNameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class AxiomHandler
implements ContentHandler,
LexicalHandler {
    private final OMFactory factory;
    private final List<OMContainer> elements = new ArrayList<OMContainer>();
    private final OMContainer container;
    private int charactersType = 4;
    private List<Map<String, String>> namespaceMappings = new ArrayList<Map<String, String>>();

    AxiomHandler(OMContainer container, OMFactory factory) {
        Assert.notNull((Object)container, (String)"'container' must not be null");
        Assert.notNull((Object)factory, (String)"'factory' must not be null");
        this.factory = factory;
        this.container = container;
    }

    private OMContainer getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.container;
    }

    @Override
    public void startDocument() throws SAXException {
        this.removeAllNamespaceMappings();
        this.newNamespaceMapping();
    }

    @Override
    public void endDocument() throws SAXException {
        this.removeAllNamespaceMappings();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.currentNamespaceMapping().put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        OMContainer parent = this.getParent();
        OMNamespace ns = this.factory.createOMNamespace(uri, QNameUtils.toQName((String)uri, (String)qName).getPrefix());
        OMElement element = this.factory.createOMElement(localName, ns, parent);
        Map<String, String> namespaceMappings = this.currentNamespaceMapping();
        for (Map.Entry<String, String> entry : namespaceMappings.entrySet()) {
            String prefix = entry.getKey();
            String namespaceUri = entry.getValue();
            if ("".equals(prefix)) {
                element.declareDefaultNamespace(namespaceUri);
                continue;
            }
            element.declareNamespace(namespaceUri, prefix);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName attrName = QNameUtils.toQName((String)attributes.getURI(i), (String)attributes.getQName(i));
            if (this.isNamespaceDeclaration(attrName)) continue;
            OMNamespace namespace = this.factory.createOMNamespace(attrName.getNamespaceURI(), attrName.getPrefix());
            OMAttribute attribute = this.factory.createOMAttribute(attrName.getLocalPart(), namespace, attributes.getValue(i));
            element.addAttribute(attribute);
        }
        this.elements.add((OMContainer)element);
        this.newNamespaceMapping();
    }

    private boolean isNamespaceDeclaration(QName qName) {
        String prefix = qName.getPrefix();
        String localPart = qName.getLocalPart();
        return "xmlns".equals(localPart) && prefix.length() == 0 || "xmlns".equals(prefix) && localPart.length() != 0;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.remove(this.elements.size() - 1);
        this.removeNamespaceMapping();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        OMContainer parent = this.getParent();
        this.factory.createOMText(parent, data, this.charactersType);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.charactersType = 6;
        this.characters(ch, start, length);
        this.charactersType = 4;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        OMContainer parent = this.getParent();
        this.factory.createOMProcessingInstruction(parent, target, data);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String content = new String(ch, start, length);
        OMContainer parent = this.getParent();
        this.factory.createOMComment(parent, content);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.charactersType = 12;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.charactersType = 4;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.isPredefinedEntityReference(name)) {
            this.charactersType = 9;
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.charactersType = 4;
    }

    private boolean isPredefinedEntityReference(String name) {
        return "lt".equals(name) || "gt".equals(name) || "amp".equals(name) || "quot".equals(name) || "apos".equals(name);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    private Map<String, String> currentNamespaceMapping() {
        return this.namespaceMappings.get(this.namespaceMappings.size() - 1);
    }

    private void newNamespaceMapping() {
        this.namespaceMappings.add(new HashMap());
    }

    private void removeNamespaceMapping() {
        this.namespaceMappings.remove(this.namespaceMappings.size() - 1);
    }

    private void removeAllNamespaceMappings() {
        this.namespaceMappings.clear();
    }
}

