/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.version;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.AddressingException;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.version.AddressingVersion;
import org.springframework.ws.soap.soap11.Soap11Body;
import org.springframework.ws.soap.soap12.Soap12Body;
import org.springframework.ws.soap.soap12.Soap12Fault;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAddressingVersion
extends TransformerObjectSupport
implements AddressingVersion {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final XPathExpression toExpression;
    private final XPathExpression actionExpression;
    private final XPathExpression messageIdExpression;
    private final XPathExpression fromExpression;
    private final XPathExpression replyToExpression;
    private final XPathExpression faultToExpression;
    private final XPathExpression addressExpression;
    private final XPathExpression referencePropertiesExpression;
    private final XPathExpression referenceParametersExpression;

    protected AbstractAddressingVersion() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(this.getNamespacePrefix(), this.getNamespaceUri());
        this.toExpression = this.createNormalizedExpression(this.getToName(), namespaces);
        this.actionExpression = this.createNormalizedExpression(this.getActionName(), namespaces);
        this.messageIdExpression = this.createNormalizedExpression(this.getMessageIdName(), namespaces);
        this.fromExpression = this.createExpression(this.getFromName(), namespaces);
        this.replyToExpression = this.createExpression(this.getReplyToName(), namespaces);
        this.faultToExpression = this.createExpression(this.getFaultToName(), namespaces);
        this.addressExpression = this.createNormalizedExpression(this.getAddressName(), namespaces);
        this.referencePropertiesExpression = this.getReferencePropertiesName() != null ? this.createChildrenExpression(this.getReferencePropertiesName(), namespaces) : null;
        this.referenceParametersExpression = this.getReferenceParametersName() != null ? this.createChildrenExpression(this.getReferenceParametersName(), namespaces) : null;
    }

    private XPathExpression createExpression(QName name, Map<String, String> namespaces) {
        String expression = name.getPrefix() + ":" + name.getLocalPart();
        return XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
    }

    private XPathExpression createNormalizedExpression(QName name, Map<String, String> namespaces) {
        String expression = "normalize-space(" + name.getPrefix() + ":" + name.getLocalPart() + ")";
        return XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
    }

    private XPathExpression createChildrenExpression(QName name, Map<String, String> namespaces) {
        String expression = name.getPrefix() + ":" + name.getLocalPart() + "/*";
        return XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
    }

    @Override
    public MessageAddressingProperties getMessageAddressingProperties(SoapMessage message) {
        EndpointReference faultTo;
        Element headerElement = this.getSoapHeaderElement(message);
        URI to = this.getUri(headerElement, this.toExpression);
        if (to == null) {
            to = this.getDefaultTo();
        }
        EndpointReference from = this.getEndpointReference(this.fromExpression.evaluateAsNode((Node)headerElement));
        EndpointReference replyTo = this.getEndpointReference(this.replyToExpression.evaluateAsNode((Node)headerElement));
        if (replyTo == null) {
            replyTo = this.getDefaultReplyTo(from);
        }
        if ((faultTo = this.getEndpointReference(this.faultToExpression.evaluateAsNode((Node)headerElement))) == null) {
            faultTo = replyTo;
        }
        URI action = this.getUri(headerElement, this.actionExpression);
        URI messageId = this.getUri(headerElement, this.messageIdExpression);
        return new MessageAddressingProperties(to, from, replyTo, faultTo, action, messageId);
    }

    private URI getUri(Node node, XPathExpression expression) {
        String messageId = expression.evaluateAsString(node);
        if (!StringUtils.hasLength((String)messageId)) {
            return null;
        }
        try {
            return new URI(messageId);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private Element getSoapHeaderElement(SoapMessage message) {
        DOMSource domSource;
        Source source = message.getSoapHeader().getSource();
        if (source instanceof DOMSource && (domSource = (DOMSource)source).getNode() != null && domSource.getNode().getNodeType() == 1) {
            return (Element)domSource.getNode();
        }
        try {
            DOMResult domResult = new DOMResult();
            this.transform(source, domResult);
            Document document = (Document)domResult.getNode();
            return document.getDocumentElement();
        }
        catch (TransformerException ex) {
            throw new AddressingException("Could not transform SoapHeader to Document", ex);
        }
    }

    private EndpointReference getEndpointReference(Node node) {
        if (node == null) {
            return null;
        }
        URI address = this.getUri(node, this.addressExpression);
        if (address == null) {
            return null;
        }
        List referenceProperties = this.referencePropertiesExpression != null ? this.referencePropertiesExpression.evaluateAsNodeList(node) : Collections.emptyList();
        List referenceParameters = this.referenceParametersExpression != null ? this.referenceParametersExpression.evaluateAsNodeList(node) : Collections.emptyList();
        return new EndpointReference(address, referenceProperties, referenceParameters);
    }

    @Override
    public void addAddressingHeaders(SoapMessage message, MessageAddressingProperties map) {
        SoapHeader header = message.getSoapHeader();
        header.addNamespaceDeclaration(this.getNamespacePrefix(), this.getNamespaceUri());
        if (map.getTo() != null) {
            SoapHeaderElement to = header.addHeaderElement(this.getToName());
            to.setText(map.getTo().toString());
            to.setMustUnderstand(true);
        }
        if (map.getFrom() != null) {
            SoapHeaderElement from = header.addHeaderElement(this.getFromName());
            this.addEndpointReference(from, map.getFrom());
        }
        if (map.getReplyTo() != null) {
            SoapHeaderElement replyTo = header.addHeaderElement(this.getReplyToName());
            this.addEndpointReference(replyTo, map.getReplyTo());
        }
        if (map.getFaultTo() != null) {
            SoapHeaderElement faultTo = header.addHeaderElement(this.getFaultToName());
            this.addEndpointReference(faultTo, map.getFaultTo());
        }
        SoapHeaderElement action = header.addHeaderElement(this.getActionName());
        action.setText(map.getAction().toString());
        if (map.getMessageId() != null) {
            SoapHeaderElement messageId = header.addHeaderElement(this.getMessageIdName());
            messageId.setText(map.getMessageId().toString());
        }
        if (map.getRelatesTo() != null) {
            SoapHeaderElement relatesTo = header.addHeaderElement(this.getRelatesToName());
            relatesTo.setText(map.getRelatesTo().toString());
        }
        this.addReferenceNodes(header.getResult(), map.getReferenceParameters());
        this.addReferenceNodes(header.getResult(), map.getReferenceProperties());
    }

    @Override
    public final boolean understands(SoapHeaderElement headerElement) {
        return this.getNamespaceUri().equals(headerElement.getName().getNamespaceURI());
    }

    protected void addEndpointReference(SoapHeaderElement headerElement, EndpointReference epr) {
        if (epr == null || epr.getAddress() == null) {
            return;
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element address = document.createElementNS(this.getNamespaceUri(), QNameUtils.toQualifiedName((QName)this.getAddressName()));
            address.setTextContent(epr.getAddress().toString());
            this.transform(new DOMSource(address), headerElement.getResult());
            if (this.getReferenceParametersName() != null && !epr.getReferenceParameters().isEmpty()) {
                Element referenceParams = document.createElementNS(this.getNamespaceUri(), QNameUtils.toQualifiedName((QName)this.getReferenceParametersName()));
                this.addReferenceNodes(new DOMResult(referenceParams), epr.getReferenceParameters());
                this.transform(new DOMSource(referenceParams), headerElement.getResult());
            }
            if (this.getReferencePropertiesName() != null && !epr.getReferenceProperties().isEmpty()) {
                Element referenceProps = document.createElementNS(this.getNamespaceUri(), QNameUtils.toQualifiedName((QName)this.getReferencePropertiesName()));
                this.addReferenceNodes(new DOMResult(referenceProps), epr.getReferenceProperties());
                this.transform(new DOMSource(referenceProps), headerElement.getResult());
            }
        }
        catch (ParserConfigurationException ex) {
            throw new AddressingException("Could not add Endpoint Reference [" + epr + "] to header element", ex);
        }
        catch (TransformerException ex) {
            throw new AddressingException("Could not add reference properties/parameters to message", ex);
        }
    }

    protected void addReferenceNodes(Result result, List<Node> nodes) {
        try {
            for (Node node : nodes) {
                DOMSource source = new DOMSource(node);
                this.transform(source, result);
            }
        }
        catch (TransformerException ex) {
            throw new AddressingException("Could not add reference properties/parameters to message", ex);
        }
    }

    @Override
    public final SoapFault addInvalidAddressingHeaderFault(SoapMessage message) {
        return this.addAddressingFault(message, this.getInvalidAddressingHeaderFaultSubcode(), this.getInvalidAddressingHeaderFaultReason());
    }

    @Override
    public final SoapFault addMessageAddressingHeaderRequiredFault(SoapMessage message) {
        return this.addAddressingFault(message, this.getMessageAddressingHeaderRequiredFaultSubcode(), this.getMessageAddressingHeaderRequiredFaultReason());
    }

    private SoapFault addAddressingFault(SoapMessage message, QName subcode, String reason) {
        if (message.getSoapBody() instanceof Soap11Body) {
            Soap11Body soapBody = (Soap11Body)message.getSoapBody();
            return soapBody.addFault(subcode, reason, Locale.ENGLISH);
        }
        if (message.getSoapBody() instanceof Soap12Body) {
            Soap12Body soapBody = (Soap12Body)message.getSoapBody();
            Soap12Fault soapFault = soapBody.addClientOrSenderFault(reason, Locale.ENGLISH);
            soapFault.addFaultSubcode(subcode);
            return soapFault;
        }
        return null;
    }

    @Override
    public final boolean hasAnonymousAddress(EndpointReference epr) {
        URI anonymous = this.getAnonymous();
        return anonymous != null && anonymous.equals(epr.getAddress());
    }

    @Override
    public final boolean hasNoneAddress(EndpointReference epr) {
        URI none = this.getNone();
        return none != null && none.equals(epr.getAddress());
    }

    protected String getNamespacePrefix() {
        return "wsa";
    }

    protected abstract String getNamespaceUri();

    protected QName getToName() {
        return new QName(this.getNamespaceUri(), "To", this.getNamespacePrefix());
    }

    protected QName getFromName() {
        return new QName(this.getNamespaceUri(), "From", this.getNamespacePrefix());
    }

    protected QName getReplyToName() {
        return new QName(this.getNamespaceUri(), "ReplyTo", this.getNamespacePrefix());
    }

    protected QName getFaultToName() {
        return new QName(this.getNamespaceUri(), "FaultTo", this.getNamespacePrefix());
    }

    protected QName getActionName() {
        return new QName(this.getNamespaceUri(), "Action", this.getNamespacePrefix());
    }

    protected QName getMessageIdName() {
        return new QName(this.getNamespaceUri(), "MessageID", this.getNamespacePrefix());
    }

    protected QName getRelatesToName() {
        return new QName(this.getNamespaceUri(), "RelatesTo", this.getNamespacePrefix());
    }

    protected QName getRelationshipTypeName() {
        return new QName("RelationshipType");
    }

    protected QName getReferencePropertiesName() {
        return new QName(this.getNamespaceUri(), "ReferenceProperties", this.getNamespacePrefix());
    }

    protected QName getReferenceParametersName() {
        return new QName(this.getNamespaceUri(), "ReferenceParameters", this.getNamespacePrefix());
    }

    protected QName getAddressName() {
        return new QName(this.getNamespaceUri(), "Address", this.getNamespacePrefix());
    }

    protected abstract URI getDefaultTo();

    protected abstract EndpointReference getDefaultReplyTo(EndpointReference var1);

    protected abstract URI getAnonymous();

    protected abstract URI getNone();

    protected abstract QName getMessageAddressingHeaderRequiredFaultSubcode();

    protected abstract String getMessageAddressingHeaderRequiredFaultReason();

    protected abstract QName getInvalidAddressingHeaderFaultSubcode();

    protected abstract String getInvalidAddressingHeaderFaultReason();
}

