/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.builder;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.wsdl.WsdlDefinitionException;
import org.springframework.ws.wsdl.wsdl11.Wsdl11Definition;
import org.springframework.ws.wsdl.wsdl11.Wsdl11DefinitionBuilder;
import org.springframework.ws.wsdl.wsdl11.Wsdl4jDefinition;
import org.springframework.ws.wsdl.wsdl11.Wsdl4jDefinitionException;

public abstract class AbstractWsdl4jDefinitionBuilder
implements Wsdl11DefinitionBuilder {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Definition definition;

    public final void buildDefinition() throws WsdlDefinitionException {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            this.definition = wsdlFactory.newDefinition();
            if (this.definition.getExtensionRegistry() == null) {
                ExtensionRegistry extensionRegistry = wsdlFactory.newPopulatedExtensionRegistry();
                this.definition.setExtensionRegistry(extensionRegistry);
            }
            this.populateExtensionRegistry(this.definition.getExtensionRegistry());
            this.populateDefinition(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected void populateDefinition(Definition definition) throws WSDLException {
    }

    public final void buildImports() throws WsdlDefinitionException {
        try {
            this.buildImports(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildImports(Definition var1) throws WSDLException;

    public final void buildTypes() throws WsdlDefinitionException {
        try {
            this.buildTypes(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildTypes(Definition var1) throws WSDLException;

    public final void buildMessages() throws WsdlDefinitionException {
        try {
            this.buildMessages(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildMessages(Definition var1) throws WSDLException;

    public final void buildPortTypes() throws WsdlDefinitionException {
        try {
            this.buildPortTypes(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildPortTypes(Definition var1) throws WSDLException;

    public final void buildBindings() throws WsdlDefinitionException {
        try {
            this.buildBindings(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildBindings(Definition var1) throws WSDLException;

    public final void buildServices() throws WsdlDefinitionException {
        try {
            this.buildServices(this.definition);
        }
        catch (WSDLException ex) {
            throw new Wsdl4jDefinitionException(ex);
        }
    }

    protected abstract void buildServices(Definition var1) throws WSDLException;

    public final Wsdl11Definition getDefinition() throws WsdlDefinitionException {
        return new Wsdl4jDefinition(this.definition);
    }

    protected ExtensibilityElement createExtension(Class parentType, QName elementType) throws WSDLException {
        return this.definition.getExtensionRegistry().createExtension(parentType, elementType);
    }

    protected void populateExtensionRegistry(ExtensionRegistry extensionRegistry) {
    }
}

