/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.builder;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.springframework.ws.wsdl.wsdl11.builder.AbstractBindingWsdl4jDefinitionBuilder;

public abstract class AbstractSoap12Wsdl4jDefinitionBuilder
extends AbstractBindingWsdl4jDefinitionBuilder {
    private static final String WSDL_SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String WSDL_SOAP_PREFIX = "soap12";
    public static final String DEFAULT_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    private String transportUri = "http://schemas.xmlsoap.org/soap/http";
    private String locationUri;

    public void setTransportUri(String transportUri) {
        this.transportUri = transportUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    protected void populateDefinition(Definition definition) throws WSDLException {
        definition.addNamespace(WSDL_SOAP_PREFIX, WSDL_SOAP_NAMESPACE_URI);
    }

    protected void populateBinding(Binding binding, PortType portType) throws WSDLException {
        super.populateBinding(binding, portType);
        SOAP12Binding soapBinding = (SOAP12Binding)this.createSoapExtension(Binding.class, "binding");
        this.populateSoapBinding(soapBinding);
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
    }

    protected void populateSoapBinding(SOAP12Binding soapBinding) throws WSDLException {
        soapBinding.setStyle("document");
        soapBinding.setTransportURI(this.transportUri);
    }

    protected void populateBindingOperation(BindingOperation bindingOperation, Operation operation) throws WSDLException {
        super.populateBindingOperation(bindingOperation, operation);
        SOAP12Operation soapOperation = (SOAP12Operation)this.createSoapExtension(BindingOperation.class, "operation");
        this.populateSoapOperation(soapOperation);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
    }

    protected void populateSoapOperation(SOAP12Operation soapOperation) throws WSDLException {
        soapOperation.setSoapActionURI("");
    }

    protected void populateBindingInput(BindingInput bindingInput, Input input) throws WSDLException {
        super.populateBindingInput(bindingInput, input);
        SOAP12Body soapBody = (SOAP12Body)this.createSoapExtension(BindingInput.class, "body");
        this.populateSoapBody(soapBody);
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    protected void populateBindingOutput(BindingOutput bindingOutput, Output output) throws WSDLException {
        super.populateBindingOutput(bindingOutput, output);
        SOAP12Body soapBody = (SOAP12Body)this.createSoapExtension(BindingOutput.class, "body");
        this.populateSoapBody(soapBody);
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    protected void populateBindingFault(BindingFault bindingFault, Fault fault) throws WSDLException {
        super.populateBindingFault(bindingFault, fault);
        SOAP12Fault soapFault = (SOAP12Fault)this.createSoapExtension(BindingFault.class, "fault");
        this.populateSoapFault(bindingFault, soapFault);
        bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
    }

    protected void populateSoapBody(SOAP12Body soapBody) throws WSDLException {
        soapBody.setUse("literal");
    }

    protected void populateSoapFault(BindingFault bindingFault, SOAP12Fault soapFault) throws WSDLException {
        soapFault.setName(bindingFault.getName());
        soapFault.setUse("literal");
    }

    protected void populatePort(Port port, Binding binding) throws WSDLException {
        super.populatePort(port, binding);
        SOAP12Address soapAddress = (SOAP12Address)this.createSoapExtension(Port.class, "address");
        this.populateSoapAddress(soapAddress);
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
    }

    protected void populateSoapAddress(SOAP12Address soapAddress) throws WSDLException {
        soapAddress.setLocationURI(this.locationUri);
    }

    protected ExtensibilityElement createSoapExtension(Class parentType, String localName) throws WSDLException {
        return this.createExtension(parentType, new QName(WSDL_SOAP_NAMESPACE_URI, localName));
    }
}

