/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.builder;

import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.springframework.ws.wsdl.wsdl11.builder.AbstractWsdl4jDefinitionBuilder;

public abstract class AbstractBindingWsdl4jDefinitionBuilder
extends AbstractWsdl4jDefinitionBuilder {
    private static final String BINDING_SUFFIX = "Binding";
    private static final String PORT_SUFFIX = "Port";

    public void buildBindings(Definition definition) throws WSDLException {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            Binding binding = definition.createBinding();
            binding.setPortType(portType);
            this.populateBinding(binding, portType);
            this.createBindingOperations(definition, binding, portType);
            binding.setUndefined(false);
            definition.addBinding(binding);
        }
    }

    protected void populateBinding(Binding binding, PortType portType) throws WSDLException {
        QName portTypeName = portType.getQName();
        if (portTypeName != null) {
            binding.setQName(new QName(portTypeName.getNamespaceURI(), portTypeName.getLocalPart() + BINDING_SUFFIX));
        }
    }

    private void createBindingOperations(Definition definition, Binding binding, PortType portType) throws WSDLException {
        Iterator operationIterator = portType.getOperations().iterator();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            BindingOperation bindingOperation = definition.createBindingOperation();
            bindingOperation.setOperation(operation);
            this.populateBindingOperation(bindingOperation, operation);
            if (operation.getStyle() == null || operation.getStyle().equals(OperationType.REQUEST_RESPONSE)) {
                this.createBindingInput(definition, operation, bindingOperation);
                this.createBindingOutput(definition, operation, bindingOperation);
            } else if (operation.getStyle().equals(OperationType.ONE_WAY)) {
                this.createBindingInput(definition, operation, bindingOperation);
            } else if (operation.getStyle().equals(OperationType.NOTIFICATION)) {
                this.createBindingOutput(definition, operation, bindingOperation);
            } else if (operation.getStyle().equals(OperationType.SOLICIT_RESPONSE)) {
                this.createBindingOutput(definition, operation, bindingOperation);
                this.createBindingInput(definition, operation, bindingOperation);
            }
            Iterator faultIterator = operation.getFaults().values().iterator();
            while (faultIterator.hasNext()) {
                Fault fault = (Fault)faultIterator.next();
                BindingFault bindingFault = definition.createBindingFault();
                this.populateBindingFault(bindingFault, fault);
                bindingOperation.addBindingFault(bindingFault);
            }
            binding.addBindingOperation(bindingOperation);
        }
    }

    private void createBindingOutput(Definition definition, Operation operation, BindingOperation bindingOperation) throws WSDLException {
        BindingOutput bindingOutput = definition.createBindingOutput();
        this.populateBindingOutput(bindingOutput, operation.getOutput());
        bindingOperation.setBindingOutput(bindingOutput);
    }

    private void createBindingInput(Definition definition, Operation operation, BindingOperation bindingOperation) throws WSDLException {
        BindingInput bindingInput = definition.createBindingInput();
        this.populateBindingInput(bindingInput, operation.getInput());
        bindingOperation.setBindingInput(bindingInput);
    }

    protected void populateBindingOperation(BindingOperation bindingOperation, Operation operation) throws WSDLException {
        bindingOperation.setName(operation.getName());
    }

    protected void populateBindingInput(BindingInput bindingInput, Input input) throws WSDLException {
        bindingInput.setName(input.getName());
    }

    protected void populateBindingOutput(BindingOutput bindingOutput, Output output) throws WSDLException {
        bindingOutput.setName(output.getName());
    }

    protected void populateBindingFault(BindingFault bindingFault, Fault fault) throws WSDLException {
        bindingFault.setName(fault.getName());
    }

    public void buildServices(Definition definition) throws WSDLException {
        Service service = definition.createService();
        this.populateService(service);
        this.createPorts(definition, service);
        definition.addService(service);
    }

    protected void populateService(Service service) throws WSDLException {
    }

    private void createPorts(Definition definition, Service service) throws WSDLException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            Port port = definition.createPort();
            port.setBinding(binding);
            this.populatePort(port, binding);
            service.addPort(port);
        }
    }

    protected void populatePort(Port port, Binding binding) throws WSDLException {
        if (binding.getPortType() != null && binding.getPortType().getQName() != null) {
            port.setName(binding.getPortType().getQName().getLocalPart() + PORT_SUFFIX);
        }
    }
}

