/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapElementException;
import org.springframework.xml.transform.StaxSource;

class AxiomSoapElement
implements SoapElement {
    private final OMElement axiomElement;
    private final SOAPFactory axiomFactory;

    protected AxiomSoapElement(OMElement axiomElement, SOAPFactory axiomFactory) {
        Assert.notNull((Object)axiomElement, (String)"axiomElement must not be null");
        Assert.notNull((Object)axiomFactory, (String)"axiomFactory must not be null");
        this.axiomElement = axiomElement;
        this.axiomFactory = axiomFactory;
    }

    public final QName getName() {
        try {
            return this.axiomElement.getQName();
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public final Source getSource() {
        try {
            return new StaxSource(this.axiomElement.getXMLStreamReader());
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public final void addAttribute(QName name, String value) {
        try {
            OMNamespace namespace = this.getAxiomFactory().createOMNamespace(name.getNamespaceURI(), name.getPrefix());
            OMAttribute attribute = this.getAxiomFactory().createOMAttribute(name.getLocalPart(), namespace, value);
            this.getAxiomElement().addAttribute(attribute);
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public void removeAttribute(QName name) {
        try {
            OMAttribute attribute = this.getAxiomElement().getAttribute(name);
            if (attribute != null) {
                this.getAxiomElement().removeAttribute(attribute);
            }
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public final String getAttributeValue(QName name) {
        try {
            return this.getAxiomElement().getAttributeValue(name);
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public final Iterator getAllAttributes() {
        try {
            ArrayList<QName> results = new ArrayList<QName>();
            Iterator iterator = this.getAxiomElement().getAllAttributes();
            while (iterator.hasNext()) {
                OMAttribute attribute = (OMAttribute)iterator.next();
                results.add(attribute.getQName());
            }
            return results.iterator();
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    public void addNamespaceDeclaration(String prefix, String namespaceUri) {
        try {
            if (StringUtils.hasLength((String)prefix)) {
                this.getAxiomElement().declareNamespace(namespaceUri, prefix);
            } else {
                this.getAxiomElement().declareDefaultNamespace(namespaceUri);
            }
        }
        catch (OMException ex) {
            throw new AxiomSoapElementException(ex);
        }
    }

    protected final OMElement getAxiomElement() {
        return this.axiomElement;
    }

    protected final SOAPFactory getAxiomFactory() {
        return this.axiomFactory;
    }
}

