/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.server.session;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.lang.Nullable;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.util.Assert;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Mono;

public class SpringSessionWebSessionStore<S extends Session>
implements WebSessionStore {
    private final ReactiveSessionRepository<S> sessions;
    private Clock clock = Clock.system(ZoneOffset.UTC);

    public SpringSessionWebSessionStore(ReactiveSessionRepository<S> reactiveSessionRepository) {
        Assert.notNull(reactiveSessionRepository, (String)"reactiveSessionRepository cannot be null");
        this.sessions = reactiveSessionRepository;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public Mono<WebSession> createWebSession() {
        return this.sessions.createSession().map(this::createSession);
    }

    public Mono<WebSession> updateLastAccessTime(WebSession session) {
        SpringSessionWebSession springSessionWebSession = (SpringSessionWebSession)session;
        springSessionWebSession.session.setLastAccessedTime(this.clock.instant());
        return Mono.just((Object)session);
    }

    public Mono<Void> storeSession(WebSession session) {
        SpringSessionWebSession springWebSession = (SpringSessionWebSession)session;
        return this.sessions.save(springWebSession.session);
    }

    public Mono<WebSession> retrieveSession(String sessionId) {
        return this.sessions.findById(sessionId).doOnNext(session -> session.setLastAccessedTime(this.clock.instant())).map(this::existingSession);
    }

    public Mono<Void> removeSession(String sessionId) {
        return this.sessions.deleteById(sessionId);
    }

    private SpringSessionWebSession createSession(S session) {
        return new SpringSessionWebSession(this, session, State.NEW);
    }

    private SpringSessionWebSession existingSession(S session) {
        return new SpringSessionWebSession(this, session, State.STARTED);
    }

    private static class SpringSessionMap
    implements Map<String, Object> {
        private final Session session;
        private final Collection<Object> values = new SessionValues();

        SpringSessionMap(Session session) {
            this.session = session;
        }

        @Override
        public int size() {
            return this.session.getAttributeNames().size();
        }

        @Override
        public boolean isEmpty() {
            return this.session.getAttributeNames().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.session.getAttributeNames().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.session.getAttributeNames().stream().anyMatch(attrName -> this.session.getAttribute((String)attrName) != null);
        }

        @Override
        @Nullable
        public Object get(Object key) {
            if (key instanceof String) {
                return this.session.getAttribute((String)key);
            }
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            Object original = this.session.getAttribute(key);
            this.session.setAttribute(key, value);
            return original;
        }

        @Override
        @Nullable
        public Object remove(Object key) {
            if (key instanceof String) {
                String attrName = (String)key;
                Object original = this.session.getAttribute(attrName);
                this.session.removeAttribute(attrName);
                return original;
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            for (String attrName : this.session.getAttributeNames()) {
                this.remove(attrName);
            }
        }

        @Override
        public Set<String> keySet() {
            return this.session.getAttributeNames();
        }

        @Override
        public Collection<Object> values() {
            return this.values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Set<String> attrNames = this.keySet();
            HashSet entries = new HashSet(attrNames.size());
            for (String attrName : attrNames) {
                Object value = this.session.getAttribute(attrName);
                entries.add(new AbstractMap.SimpleEntry(attrName, value));
            }
            return Collections.unmodifiableSet(entries);
        }

        private class SessionValues
        extends AbstractCollection<Object> {
            private SessionValues() {
            }

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    private Iterator<Map.Entry<String, Object>> i;
                    {
                        this.i = SpringSessionMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Object next() {
                        return this.i.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return SpringSessionMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SpringSessionMap.this.isEmpty();
            }

            @Override
            public void clear() {
                SpringSessionMap.this.clear();
            }

            @Override
            public boolean contains(Object v) {
                return SpringSessionMap.this.containsValue(v);
            }
        }
    }

    private static enum State {
        NEW,
        STARTED,
        EXPIRED;

    }

    private static class SpringSessionWebSession
    implements WebSession {
        private final S session;
        private final Map<String, Object> attributes;
        private AtomicReference<State> state = new AtomicReference();
        final /* synthetic */ SpringSessionWebSessionStore this$0;

        SpringSessionWebSession(S session, State state) {
            this.this$0 = var1_1;
            Assert.notNull(session, (String)"session cannot be null");
            this.session = session;
            this.attributes = new SpringSessionMap((Session)session);
            this.state.set(state);
        }

        public String getId() {
            return this.session.getId();
        }

        public Mono<Void> changeSessionId() {
            return Mono.defer(() -> {
                this.session.changeSessionId();
                return this.save();
            });
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void start() {
            this.state.compareAndSet(State.NEW, State.STARTED);
        }

        public boolean isStarted() {
            State value = this.state.get();
            return State.STARTED.equals((Object)value) || State.NEW.equals((Object)value) && !this.getAttributes().isEmpty();
        }

        public Mono<Void> invalidate() {
            this.state.set(State.EXPIRED);
            return this.this$0.sessions.deleteById(this.session.getId());
        }

        public Mono<Void> save() {
            return this.this$0.sessions.save(this.session);
        }

        public boolean isExpired() {
            if (this.state.get().equals((Object)State.EXPIRED)) {
                return true;
            }
            if (this.session.isExpired()) {
                this.state.set(State.EXPIRED);
                return true;
            }
            return false;
        }

        public Instant getCreationTime() {
            return this.session.getCreationTime();
        }

        public Instant getLastAccessTime() {
            return this.session.getLastAccessedTime();
        }

        public Duration getMaxIdleTime() {
            return this.session.getMaxInactiveInterval();
        }

        public void setMaxIdleTime(Duration maxIdleTime) {
            this.session.setMaxInactiveInterval(maxIdleTime);
        }
    }
}

