/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.ldif.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.ldif.InvalidRecordFormatException;
import org.springframework.ldap.ldif.parser.Parser;
import org.springframework.ldap.ldif.support.AttributeValidationPolicy;
import org.springframework.ldap.ldif.support.DefaultAttributeValidationPolicy;
import org.springframework.ldap.ldif.support.LineIdentifier;
import org.springframework.ldap.ldif.support.SeparatorPolicy;
import org.springframework.ldap.schema.DefaultSchemaSpecification;
import org.springframework.ldap.schema.Specification;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifParser
implements Parser,
InitializingBean {
    private static final Log log = LogFactory.getLog(LdifParser.class);
    private Resource resource;
    private BufferedReader reader;
    private SeparatorPolicy separatorPolicy = new SeparatorPolicy();
    private AttributeValidationPolicy attributePolicy = new DefaultAttributeValidationPolicy();
    private Specification<LdapAttributes> specification = new DefaultSchemaSpecification();
    private boolean caseInsensitive = true;

    public LdifParser() {
    }

    public LdifParser(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public LdifParser(Resource resource, boolean caseInsensitive) {
        this.resource = resource;
        this.caseInsensitive = caseInsensitive;
    }

    public LdifParser(Resource resource) {
        this.resource = resource;
    }

    public LdifParser(File file) {
        this.resource = new FileSystemResource(file);
    }

    public void setSeparatorPolicy(SeparatorPolicy separatorPolicy) {
        this.separatorPolicy = separatorPolicy;
    }

    public void setAttributeValidationPolicy(AttributeValidationPolicy avPolicy) {
        this.attributePolicy = avPolicy;
    }

    public void setRecordSpecification(Specification<LdapAttributes> specification) {
        this.specification = specification;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public void open() throws IOException {
        Assert.notNull((Object)this.resource, (String)"Resource must be set.");
        this.reader = new BufferedReader(new InputStreamReader(this.resource.getInputStream()));
    }

    @Override
    public boolean isReady() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void close() throws IOException {
        if (this.resource.isOpen()) {
            this.reader.close();
        }
    }

    @Override
    public void reset() throws IOException {
        Assert.notNull((Object)this.reader, (String)"A reader has not been obtained.");
        this.reader.reset();
    }

    @Override
    public boolean hasMoreRecords() throws IOException {
        return this.reader.ready();
    }

    @Override
    public LdapAttributes getRecord() throws IOException {
        Assert.notNull((Object)this.reader, (String)"A reader must be obtained: parser not open.");
        if (!this.reader.ready()) {
            log.debug((Object)"Reader not ready!");
            return null;
        }
        LdapAttributes record = null;
        StringBuilder builder = new StringBuilder();
        String line = this.reader.readLine();
        do {
            LineIdentifier identifier = this.separatorPolicy.assess(line);
            switch (identifier) {
                case NewRecord: {
                    log.trace((Object)"Starting new record.");
                    record = new LdapAttributes(this.caseInsensitive);
                    builder = new StringBuilder(line);
                    break;
                }
                case Control: {
                    log.trace((Object)"'control' encountered.");
                    log.warn((Object)"LDIF change records have no implementation: record will be ignored.");
                    builder = null;
                    record = null;
                    break;
                }
                case ChangeType: {
                    log.trace((Object)"'changetype' encountered.");
                    log.warn((Object)"LDIF change records have no implementation: record will be ignored.");
                    builder = null;
                    record = null;
                    break;
                }
                case Attribute: {
                    this.addAttributeToRecord(builder.toString(), record);
                    log.trace((Object)"Starting new attribute.");
                    builder = new StringBuilder(line);
                    break;
                }
                case Continuation: {
                    log.trace((Object)"...appending line to buffer.");
                    builder.append(line.replaceFirst(" ", ""));
                    break;
                }
                case EndOfRecord: {
                    log.trace((Object)"...done parsing record. (EndOfRecord)");
                    if (record == null) {
                        return null;
                    }
                    try {
                        this.addAttributeToRecord(builder.toString(), record);
                        if (this.specification.isSatisfiedBy(record)) {
                            log.debug((Object)("record parsed:\n" + record));
                            return record;
                        }
                        throw new InvalidRecordFormatException("Record [dn: " + record.getDN() + "] does not conform to specification.");
                    }
                    catch (NamingException e) {
                        log.error((Object)e);
                        return null;
                    }
                }
            }
        } while ((line = this.reader.readLine()) != null || record != null);
        return null;
    }

    private void addAttributeToRecord(String buffer, LdapAttributes record) {
        try {
            if (StringUtils.isNotEmpty((String)buffer) && record != null) {
                Attribute attribute = this.attributePolicy.parse(buffer);
                if (attribute.getID().equalsIgnoreCase("dn")) {
                    log.trace((Object)"...adding DN to record.");
                    String dn = attribute.get() instanceof byte[] ? new String((byte[])attribute.get()) : (String)attribute.get();
                    record.setDN(new DistinguishedName(dn));
                } else {
                    log.trace((Object)"...adding attribute to record.");
                    Attribute attr = record.get(attribute.getID());
                    if (attr != null) {
                        attr.add(attribute.get());
                    } else {
                        record.put(attribute);
                    }
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)e);
        }
        catch (NoSuchElementException e) {
            log.error((Object)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"A resource to parse is required.");
        Assert.isTrue((boolean)this.resource.exists(), (String)(this.resource.getDescription() + ": resource does not exist!"));
        Assert.isTrue((boolean)this.resource.isReadable(), (String)"Resource is not readable.");
    }
}

