/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.config;

import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.config.ParserUtils;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool.PoolExhaustedAction;
import org.springframework.ldap.pool.factory.PoolingContextSource;
import org.springframework.ldap.pool.validation.DefaultDirContextValidator;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ContextSourceParser
implements BeanDefinitionParser {
    private static final String ATT_ANONYMOUS_READ_ONLY = "anonymous-read-only";
    private static final String ATT_AUTHENTICATION_SOURCE_REF = "authentication-source-ref";
    private static final String ATT_AUTHENTICATION_STRATEGY_REF = "authentication-strategy-ref";
    private static final String ATT_BASE = "base";
    private static final String ATT_PASSWORD = "password";
    private static final String ATT_NATIVE_POOLING = "native-pooling";
    private static final String ATT_REFERRAL = "referral";
    private static final String ATT_URL = "url";
    private static final String ATT_BASE_ENV_PROPS_REF = "base-env-props-ref";
    private static final String ATT_MAX_ACTIVE = "max-active";
    private static final String ATT_MAX_TOTAL = "max-total";
    private static final String ATT_MAX_IDLE = "max-idle";
    private static final String ATT_MIN_IDLE = "min-idle";
    private static final String ATT_MAX_WAIT = "max-wait";
    private static final String ATT_WHEN_EXHAUSTED = "when-exhausted";
    private static final String ATT_TEST_ON_BORROW = "test-on-borrow";
    private static final String ATT_TEST_ON_RETURN = "test-on-return";
    private static final String ATT_TEST_WHILE_IDLE = "test-while-idle";
    private static final String ATT_EVICTION_RUN_MILLIS = "eviction-run-interval-millis";
    private static final String ATT_TESTS_PER_EVICTION_RUN = "tests-per-eviction-run";
    private static final String ATT_EVICTABLE_TIME_MILLIS = "min-evictable-time-millis";
    private static final String ATT_VALIDATION_QUERY_BASE = "validation-query-base";
    private static final String ATT_VALIDATION_QUERY_FILTER = "validation-query-filter";
    private static final String ATT_VALIDATION_QUERY_SEARCH_CONTROLS_REF = "validation-query-search-controls-ref";
    private static final String ATT_NON_TRANSIENT_EXCEPTIONS = "non-transient-exceptions";
    private static final String ATT_USERNAME = "username";
    static final String DEFAULT_ID = "contextSource";
    private static final int DEFAULT_MAX_ACTIVE = 8;
    private static final int DEFAULT_MAX_TOTAL = -1;
    private static final int DEFAULT_MAX_IDLE = 8;
    private static final int DEFAULT_MIN_IDLE = 0;
    private static final int DEFAULT_MAX_WAIT = -1;
    private static final int DEFAULT_EVICTION_RUN_MILLIS = -1;
    private static final int DEFAULT_TESTS_PER_EVICTION_RUN = 3;
    private static final int DEFAULT_EVICTABLE_MILLIS = 1800000;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String authSourceRef;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(LdapContextSource.class);
        String username = element.getAttribute(ATT_USERNAME);
        String password = element.getAttribute(ATT_PASSWORD);
        String url = element.getAttribute(ATT_URL);
        Assert.hasText((String)url, (String)"url attribute must be specified");
        builder.addPropertyValue("userDn", (Object)username);
        builder.addPropertyValue(ATT_PASSWORD, (Object)password);
        BeanDefinitionBuilder urlsBuilder = BeanDefinitionBuilder.rootBeanDefinition(UrlsFactory.class).setFactoryMethod("urls").addConstructorArgValue((Object)url);
        builder.addPropertyValue("urls", (Object)urlsBuilder.getBeanDefinition());
        builder.addPropertyValue(ATT_BASE, (Object)ParserUtils.getString(element, ATT_BASE, ""));
        builder.addPropertyValue(ATT_REFERRAL, (Object)ParserUtils.getString(element, ATT_REFERRAL, null));
        boolean anonymousReadOnly = ParserUtils.getBoolean(element, ATT_ANONYMOUS_READ_ONLY, false);
        builder.addPropertyValue("anonymousReadOnly", (Object)anonymousReadOnly);
        boolean nativePooling = ParserUtils.getBoolean(element, ATT_NATIVE_POOLING, false);
        builder.addPropertyValue("pooled", (Object)nativePooling);
        String authStrategyRef = element.getAttribute(ATT_AUTHENTICATION_STRATEGY_REF);
        if (StringUtils.hasText((String)authStrategyRef)) {
            builder.addPropertyReference("authenticationStrategy", authStrategyRef);
        }
        if (StringUtils.hasText((String)(authSourceRef = element.getAttribute(ATT_AUTHENTICATION_SOURCE_REF)))) {
            builder.addPropertyReference("authenticationSource", authSourceRef);
        } else {
            Assert.hasText((String)username, (String)"username attribute must be specified unless an authentication-source-ref explicitly configured");
            Assert.hasText((String)password, (String)"password attribute must be specified unless an authentication-source-ref explicitly configured");
        }
        String baseEnvPropsRef = element.getAttribute(ATT_BASE_ENV_PROPS_REF);
        if (StringUtils.hasText((String)baseEnvPropsRef)) {
            builder.addPropertyReference("baseEnvironmentProperties", baseEnvPropsRef);
        }
        AbstractBeanDefinition targetContextSourceDefinition = builder.getBeanDefinition();
        AbstractBeanDefinition actualContextSourceDefinition = targetContextSourceDefinition = this.applyPoolingIfApplicable((BeanDefinition)targetContextSourceDefinition, element, nativePooling);
        if (!anonymousReadOnly) {
            BeanDefinitionBuilder proxyBuilder = BeanDefinitionBuilder.rootBeanDefinition(TransactionAwareContextSourceProxy.class);
            proxyBuilder.addConstructorArgValue((Object)targetContextSourceDefinition);
            actualContextSourceDefinition = proxyBuilder.getBeanDefinition();
        }
        String id = ParserUtils.getString(element, "id", DEFAULT_ID);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)actualContextSourceDefinition, id));
        return actualContextSourceDefinition;
    }

    private BeanDefinition applyPoolingIfApplicable(BeanDefinition targetContextSourceDefinition, Element element, boolean nativePooling) {
        Element poolingElement = DomUtils.getChildElementByTagName((Element)element, (String)"pooling");
        if (poolingElement == null) {
            return targetContextSourceDefinition;
        }
        if (nativePooling) {
            throw new IllegalArgumentException(String.format("%s cannot be enabled together with %s", ATT_NATIVE_POOLING, "pooling"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PoolingContextSource.class);
        builder.addPropertyValue(DEFAULT_ID, (Object)targetContextSourceDefinition);
        builder.addPropertyValue("maxActive", (Object)ParserUtils.getInt(poolingElement, ATT_MAX_ACTIVE, 8));
        builder.addPropertyValue("maxTotal", (Object)ParserUtils.getInt(poolingElement, ATT_MAX_TOTAL, -1));
        builder.addPropertyValue("maxIdle", (Object)ParserUtils.getInt(poolingElement, ATT_MAX_IDLE, 8));
        builder.addPropertyValue("minIdle", (Object)ParserUtils.getInt(poolingElement, ATT_MIN_IDLE, 0));
        builder.addPropertyValue("maxWait", (Object)ParserUtils.getInt(poolingElement, ATT_MAX_WAIT, -1));
        String whenExhausted = ParserUtils.getString(poolingElement, ATT_WHEN_EXHAUSTED, PoolExhaustedAction.BLOCK.name());
        builder.addPropertyValue("whenExhaustedAction", (Object)PoolExhaustedAction.valueOf(whenExhausted).getValue());
        boolean testOnBorrow = ParserUtils.getBoolean(poolingElement, ATT_TEST_ON_BORROW, false);
        boolean testOnReturn = ParserUtils.getBoolean(poolingElement, ATT_TEST_ON_RETURN, false);
        boolean testWhileIdle = ParserUtils.getBoolean(poolingElement, ATT_TEST_WHILE_IDLE, false);
        if (testOnBorrow || testOnReturn || testWhileIdle) {
            this.populatePoolValidationProperties(builder, poolingElement, testOnBorrow, testOnReturn, testWhileIdle);
        }
        return builder.getBeanDefinition();
    }

    private void populatePoolValidationProperties(BeanDefinitionBuilder builder, Element element, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle) {
        builder.addPropertyValue("testOnBorrow", (Object)testOnBorrow);
        builder.addPropertyValue("testOnReturn", (Object)testOnReturn);
        builder.addPropertyValue("testWhileIdle", (Object)testWhileIdle);
        BeanDefinitionBuilder validatorBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultDirContextValidator.class);
        validatorBuilder.addPropertyValue(ATT_BASE, (Object)ParserUtils.getString(element, ATT_VALIDATION_QUERY_BASE, ""));
        validatorBuilder.addPropertyValue("filter", (Object)ParserUtils.getString(element, ATT_VALIDATION_QUERY_FILTER, "objectclass=*"));
        String searchControlsRef = element.getAttribute(ATT_VALIDATION_QUERY_SEARCH_CONTROLS_REF);
        if (StringUtils.hasText((String)searchControlsRef)) {
            validatorBuilder.addPropertyReference("searchControls", searchControlsRef);
        }
        builder.addPropertyValue("dirContextValidator", (Object)validatorBuilder.getBeanDefinition());
        builder.addPropertyValue("timeBetweenEvictionRunsMillis", (Object)ParserUtils.getInt(element, ATT_EVICTION_RUN_MILLIS, -1));
        builder.addPropertyValue("numTestsPerEvictionRun", (Object)ParserUtils.getInt(element, ATT_TESTS_PER_EVICTION_RUN, 3));
        builder.addPropertyValue("minEvictableIdleTimeMillis", (Object)ParserUtils.getInt(element, ATT_EVICTABLE_TIME_MILLIS, 1800000));
        String nonTransientExceptions = ParserUtils.getString(element, ATT_NON_TRANSIENT_EXCEPTIONS, CommunicationException.class.getName());
        String[] strings = StringUtils.commaDelimitedListToStringArray((String)nonTransientExceptions);
        HashSet nonTransientExceptionClasses = new HashSet();
        for (String className : strings) {
            try {
                nonTransientExceptionClasses.add(ClassUtils.getDefaultClassLoader().loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("%s is not a valid class name", className), e);
            }
        }
        builder.addPropertyValue("nonTransientExceptions", nonTransientExceptionClasses);
    }

    static class UrlsFactory {
        UrlsFactory() {
        }

        public static String[] urls(String value) {
            return StringUtils.commaDelimitedListToStringArray((String)value);
        }
    }
}

