/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.util;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class UUIDConverter
implements ConditionalGenericConverter {
    public static final UUIDConverter INSTANCE = new UUIDConverter();
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS = new HashSet<GenericConverter.ConvertiblePair>();

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (String.class.isAssignableFrom(sourceType.getType())) {
            return UUID.class.isAssignableFrom(targetType.getType());
        }
        return UUID.class.isAssignableFrom(sourceType.getType()) && String.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_PAIRS;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (String.class.isAssignableFrom(sourceType.getType())) {
            return UUID.fromString(source.toString());
        }
        return source.toString();
    }

    static {
        CONVERTIBLE_PAIRS.add(new GenericConverter.ConvertiblePair(String.class, UUID.class));
        CONVERTIBLE_PAIRS.add(new GenericConverter.ConvertiblePair(UUID.class, String.class));
    }
}

