/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.annotation.Order;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.hateoas.RelProvider;
import org.springframework.util.Assert;

@Order(value=-2147483639)
public class RepositoryRelProvider
implements RelProvider {
    private final ObjectFactory<ResourceMappings> mappings;

    public RepositoryRelProvider(ObjectFactory<ResourceMappings> mappings) {
        Assert.notNull(mappings, (String)"ResourceMappings must not be null!");
        this.mappings = mappings;
    }

    public String getCollectionResourceRelFor(Class<?> type) {
        return ((ResourceMappings)this.mappings.getObject()).getMappingFor(type).getRel();
    }

    public String getItemResourceRelFor(Class<?> type) {
        return ((ResourceMappings)this.mappings.getObject()).getMappingFor(type).getItemResourceRel();
    }

    public boolean supports(Class<?> delimiter) {
        return ((ResourceMappings)this.mappings.getObject()).hasMappingFor(delimiter);
    }
}

