/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.projection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.CollectionFactory;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class ProjectingMethodInterceptor
implements MethodInterceptor {
    private final ProjectionFactory factory;
    private final MethodInterceptor delegate;

    public ProjectingMethodInterceptor(ProjectionFactory factory, MethodInterceptor delegate) {
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        Assert.notNull((Object)delegate, (String)"Delegate MethodInterceptor must not be null!");
        this.factory = factory;
        this.delegate = delegate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = this.delegate.invoke(invocation);
        if (result == null) {
            return null;
        }
        TypeInformation type = ClassTypeInformation.fromReturnTypeOf((Method)invocation.getMethod());
        if (type.isCollectionLike()) {
            return this.projectCollectionElements(ProjectingMethodInterceptor.asCollection(result), type);
        }
        if (type.isMap()) {
            return this.projectMapValues((Map)result, type);
        }
        return this.getProjection(result, type.getType());
    }

    private Collection<Object> projectCollectionElements(Collection<?> sources, TypeInformation<?> type) {
        Collection result = CollectionFactory.createCollection((Class)type.getType(), (int)sources.size());
        for (Object source : sources) {
            result.add(this.getProjection(source, type.getComponentType().getType()));
        }
        return result;
    }

    private Map<Object, Object> projectMapValues(Map<?, ?> sources, TypeInformation<?> type) {
        Map result = CollectionFactory.createMap((Class)type.getType(), (int)sources.size());
        for (Map.Entry<?, ?> source : sources.entrySet()) {
            result.put(source.getKey(), this.getProjection(source.getValue(), type.getMapValueType().getType()));
        }
        return result;
    }

    private Object getProjection(Object result, Class<?> returnType) {
        return ClassUtils.isAssignable(returnType, result.getClass()) ? result : this.factory.createProjection(result, returnType);
    }

    private static Collection<?> asCollection(Object source) {
        if (source == null) {
            return Collections.emptySet();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return Arrays.asList((Object[])source);
        }
        return Collections.singleton(source);
    }
}

