/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryAwareResourceInformation;
import org.springframework.data.rest.core.mapping.RepositoryCollectionResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryMethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryResourceMappings
implements ResourceMappings {
    private final Repositories repositories;
    private final RelProvider relProvider;
    private final Map<Class<?>, ResourceMetadata> cache = new HashMap();
    private final Map<Class<?>, SearchResourceMappings> searchCache = new HashMap();
    private final Map<PersistentProperty<?>, ResourceMapping> propertyCache = new HashMap();

    public RepositoryResourceMappings(RepositoryRestConfiguration config, Repositories repositories) {
        this(config, repositories, (RelProvider)new EvoInflectorRelProvider());
    }

    public RepositoryResourceMappings(RepositoryRestConfiguration config, Repositories repositories, RelProvider relProvider) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)relProvider, (String)"RelProvider must not be null!");
        this.repositories = repositories;
        this.relProvider = relProvider;
        this.populateCache(repositories);
    }

    @Override
    public ResourceMetadata getMappingFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.cache.get(type);
    }

    private final void populateCache(Repositories repositories) {
        for (Class type : repositories) {
            RepositoryInformation repositoryInformation = repositories.getRepositoryInformationFor(type);
            Class repositoryInterface = repositoryInformation.getRepositoryInterface();
            RepositoryCollectionResourceMapping mapping = new RepositoryCollectionResourceMapping((RepositoryMetadata)repositoryInformation, this.relProvider);
            RepositoryAwareResourceInformation information = new RepositoryAwareResourceInformation(repositories, mapping, this, (RepositoryMetadata)repositoryInformation);
            this.cache.put(repositoryInterface, information);
            if (this.cache.containsKey(type) && !information.isPrimary()) continue;
            this.cache.put(type, information);
        }
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Type must not be null!");
        if (this.searchCache.containsKey(domainType)) {
            return this.searchCache.get(domainType);
        }
        RepositoryInformation repositoryInformation = this.repositories.getRepositoryInformationFor(domainType);
        ArrayList<MethodResourceMapping> mappings = new ArrayList<MethodResourceMapping>();
        ResourceMetadata resourceMapping = this.getMappingFor(domainType);
        if (resourceMapping.isExported()) {
            for (Method queryMethod : repositoryInformation.getQueryMethods()) {
                RepositoryMethodResourceMapping methodMapping = new RepositoryMethodResourceMapping(queryMethod, resourceMapping);
                if (!methodMapping.isExported()) continue;
                mappings.add(methodMapping);
            }
        }
        SearchResourceMappings searchResourceMappings = new SearchResourceMappings(mappings);
        this.searchCache.put(domainType, searchResourceMappings);
        return searchResourceMappings;
    }

    @Override
    public boolean exportsMappingFor(Class<?> type) {
        if (!this.hasMappingFor(type)) {
            return false;
        }
        ResourceMetadata metadata = this.getMappingFor(type);
        return metadata.isExported();
    }

    @Override
    public boolean exportsTopLevelResourceFor(String path) {
        Assert.hasText((String)path);
        for (ResourceMetadata metadata : this.cache.values()) {
            if (!metadata.getPath().matches(path)) continue;
            return metadata.isExported();
        }
        return false;
    }

    @Override
    public boolean hasMappingFor(Class<?> type) {
        if (this.cache.containsKey(type)) {
            return true;
        }
        return this.repositories.hasRepositoryFor(type);
    }

    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        ResourceMapping propertyMapping = this.propertyCache.get(property);
        if (propertyMapping != null) {
            return propertyMapping;
        }
        ResourceMetadata propertyTypeMapping = this.getMappingFor(property.getActualType());
        ResourceMetadata ownerTypeMapping = this.getMappingFor(property.getOwner().getType());
        propertyMapping = new PersistentPropertyResourceMapping(property, propertyTypeMapping, ownerTypeMapping);
        this.propertyCache.put(property, propertyMapping);
        return propertyMapping;
    }

    public boolean isMapped(PersistentProperty<?> property) {
        ResourceMapping metadata = this.getMappingFor(property);
        return metadata != null && metadata.isExported();
    }

    @Override
    public Iterator<ResourceMetadata> iterator() {
        return this.cache.values().iterator();
    }

    static class PersistentPropertyResourceMapping
    implements ResourceMapping {
        private final PersistentProperty<?> property;
        private final ResourceMapping typeMapping;
        private final CollectionResourceMapping ownerTypeMapping;
        private final RestResource annotation;
        private final Description description;

        public PersistentPropertyResourceMapping(PersistentProperty<?> property, ResourceMapping typeMapping, CollectionResourceMapping ownerTypeMapping) {
            Assert.notNull(property, (String)"PersistentProperty must not be null!");
            this.property = property;
            this.typeMapping = typeMapping;
            this.ownerTypeMapping = ownerTypeMapping;
            this.annotation = property.isAssociation() ? (RestResource)property.findAnnotation(RestResource.class) : null;
            this.description = (Description)property.findAnnotation(Description.class);
        }

        @Override
        public Path getPath() {
            return this.annotation != null && StringUtils.hasText((String)this.annotation.path()) ? new Path(this.annotation.path()) : new Path(this.property.getName());
        }

        @Override
        public String getRel() {
            return this.annotation != null && StringUtils.hasText((String)this.annotation.rel()) ? this.annotation.rel() : this.property.getName();
        }

        @Override
        public boolean isExported() {
            if (this.typeMapping == null) {
                return false;
            }
            return !this.typeMapping.isExported() ? false : (this.annotation == null ? true : this.annotation.exported());
        }

        @Override
        public boolean isPagingResource() {
            return false;
        }

        @Override
        public ResourceDescription getDescription() {
            ResourceDescription fallback = TypedResourceDescription.defaultFor(this.ownerTypeMapping.getItemResourceRel(), this.property);
            if (this.description != null) {
                return new AnnotationBasedResourceDescription(this.description, fallback);
            }
            if (this.annotation != null) {
                return new AnnotationBasedResourceDescription(this.annotation.description(), fallback);
            }
            return fallback;
        }
    }
}

