/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.TypeBasedCollectionResourceMapping;

public class MappingResourceMetadata
extends TypeBasedCollectionResourceMapping
implements ResourceMetadata {
    private final PersistentEntity<?, ?> entity;
    private final Map<PersistentProperty<?>, ResourceMapping> propertyMappings;

    public MappingResourceMetadata(PersistentEntity<?, ?> entity) {
        super(entity.getType());
        this.entity = entity;
        this.propertyMappings = new HashMap();
    }

    @Override
    public Class<?> getDomainType() {
        return this.entity.getType();
    }

    @Override
    public boolean isManagedResource(PersistentProperty<?> property) {
        return property.isAssociation();
    }

    @Override
    public boolean isExported(PersistentProperty<?> property) {
        return this.getMappingFor(property).isExported();
    }

    @Override
    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        ResourceMapping propertyMapping = this.propertyMappings.get(property);
        if (propertyMapping != null) {
            return propertyMapping;
        }
        propertyMapping = new RepositoryResourceMappings.PersistentPropertyResourceMapping(property, this, this);
        this.propertyMappings.put(property, propertyMapping);
        return propertyMapping;
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings() {
        return new SearchResourceMappings(Collections.<MethodResourceMapping>emptyList());
    }
}

