/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.invoke;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.invoke.CrudRepositoryInvoker;
import org.springframework.data.rest.core.invoke.PagingAndSortingRepositoryInvoker;
import org.springframework.data.rest.core.invoke.ReflectionRepositoryInvoker;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.invoke.RepositoryInvokerFactory;
import org.springframework.util.Assert;

public class DefaultRepositoryInvokerFactory
implements RepositoryInvokerFactory {
    private final Repositories repositories;
    private final ConversionService conversionService;
    private final Map<Class<?>, RepositoryInvoker> invokers;

    public DefaultRepositoryInvokerFactory(Repositories repositories, ConversionService conversionService) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.repositories = repositories;
        this.conversionService = conversionService;
        this.invokers = new HashMap();
    }

    private RepositoryInvoker prepareInvokers(Class<?> domainType) {
        Object repository = this.repositories.getRepositoryFor(domainType);
        RepositoryInformation information = this.repositories.getRepositoryInformationFor(domainType);
        if (repository instanceof PagingAndSortingRepository) {
            return new PagingAndSortingRepositoryInvoker((PagingAndSortingRepository<Object, Serializable>)((PagingAndSortingRepository)repository), information, this.conversionService);
        }
        if (repository instanceof CrudRepository) {
            return new CrudRepositoryInvoker((CrudRepository<Object, Serializable>)((CrudRepository)repository), information, this.conversionService);
        }
        return new ReflectionRepositoryInvoker(repository, information, this.conversionService);
    }

    @Override
    public RepositoryInvoker getInvokerFor(Class<?> domainType) {
        RepositoryInvoker invoker = this.invokers.get(domainType);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.prepareInvokers(domainType);
        this.invokers.put(domainType, invoker);
        return invoker;
    }
}

