/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.invoke;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.core.invoke.ReflectionRepositoryInvoker;

class CrudRepositoryInvoker
extends ReflectionRepositoryInvoker {
    private final CrudRepository<Object, Serializable> repository;
    private final CrudMethods crudMethods;
    private final boolean customSaveMethod;
    private final boolean customFindOneMethod;
    private final boolean customDeleteMethod;

    public CrudRepositoryInvoker(CrudRepository<Object, Serializable> repository, RepositoryInformation information, ConversionService conversionService) {
        super(repository, information, conversionService);
        this.repository = repository;
        this.crudMethods = information.getCrudMethods();
        this.customSaveMethod = this.isRedeclaredMethod(this.crudMethods.getSaveMethod());
        this.customFindOneMethod = this.isRedeclaredMethod(this.crudMethods.getFindOneMethod());
        this.customDeleteMethod = this.isRedeclaredMethod(this.crudMethods.getDeleteMethod());
    }

    protected Iterable<Object> invokeFindAll() {
        return this.repository.findAll();
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort pageable) {
        return this.repository.findAll();
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        return this.repository.findAll();
    }

    @Override
    public <T> T invokeFindOne(Serializable id) {
        return (T)(this.customFindOneMethod ? super.invokeFindOne(id) : this.repository.findOne(this.convertId(id)));
    }

    @Override
    public <T> T invokeSave(T entity) {
        return (T)(this.customSaveMethod ? super.invokeSave(entity) : this.repository.save(entity));
    }

    @Override
    public void invokeDelete(Serializable id) {
        if (this.customDeleteMethod) {
            super.invokeDelete(id);
        } else {
            this.repository.delete(this.convertId(id));
        }
    }

    private boolean isRedeclaredMethod(Method method) {
        return !method.getDeclaringClass().equals(CrudRepository.class);
    }
}

