/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.net.UnknownHostException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class JedisExceptionConverter
implements Converter<Exception, DataAccessException> {
    public DataAccessException convert(Exception ex) {
        if (ex instanceof DataAccessException) {
            return (DataAccessException)((Object)ex);
        }
        if (ex instanceof JedisDataException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof JedisConnectionException) {
            return new RedisConnectionFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof JedisException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnknownHostException) {
            return new RedisConnectionFailureException("Unknown host " + ex.getMessage(), ex);
        }
        if (ex instanceof IOException) {
            return new RedisConnectionFailureException("Could not connect to Redis server", ex);
        }
        return new RedisSystemException("Unknown jedis exception", ex);
    }
}

